/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.filter.impl.PredicateFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SchemaValidationFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import se.litsec.opensaml.saml2.metadata.provider.MetadataProvider;

public abstract class AbstractMetadataProvider
extends AbstractInitializableComponent
implements MetadataProvider {
    private Logger log = LoggerFactory.getLogger(AbstractMetadataProvider.class);
    private boolean requireValidMetadata = true;
    private boolean failFastInitialization = false;
    private List<X509Certificate> signatureVerificationCertificates = null;
    private boolean performSchemaValidation = false;
    private List<Predicate<EntityDescriptor>> inclusionPredicates = null;
    private List<Predicate<EntityDescriptor>> exclusionPredicates = null;
    private XMLObject metadata;
    private Instant downloadTime;

    @Override
    public synchronized XMLObject getMetadata() {
        return this.metadata;
    }

    @Override
    public Element getMetadataDOM() throws MarshallingException {
        XMLObject md = this.getMetadata();
        if (md == null) {
            return null;
        }
        if (md.getDOM() != null) {
            return md.getDOM();
        }
        return XMLObjectSupport.marshall((XMLObject)md);
    }

    @Override
    public Instant getLastUpdate() {
        if (RefreshableMetadataResolver.class.isInstance(this.getMetadataResolver())) {
            return ((RefreshableMetadataResolver)this.getMetadataResolver()).getLastUpdate();
        }
        return this.downloadTime;
    }

    @Override
    public void refresh() throws ResolverException {
        if (RefreshableMetadataResolver.class.isInstance(this.getMetadataResolver())) {
            ((RefreshableMetadataResolver)this.getMetadataResolver()).refresh();
        } else {
            this.log.debug("Refresh of metadata is not supported by {}", (Object)this.getClass().getName());
        }
    }

    @Override
    public Iterable<EntityDescriptor> iterator() {
        return new EntityDescriptorIterator(this.getMetadata());
    }

    @Override
    public Iterable<EntityDescriptor> iterator(QName role) {
        return new EntityDescriptorIterator(this.getMetadata(), role);
    }

    @Override
    public EntityDescriptor getEntityDescriptor(String entityID) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EntityIdCriterion(entityID));
        return (EntityDescriptor)this.getMetadataResolver().resolveSingle((Object)criteria);
    }

    @Override
    public IDPSSODescriptor getIDPSSODescriptor(String entityID) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EntityIdCriterion(entityID));
        criteria.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        return Optional.ofNullable((EntityDescriptor)this.getMetadataResolver().resolveSingle((Object)criteria)).map(e -> e.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol")).orElse(null);
    }

    @Override
    public SPSSODescriptor getSPSSODescriptor(String entityID) throws ResolverException {
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new EntityIdCriterion(entityID));
        criteria.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        return Optional.ofNullable((EntityDescriptor)this.getMetadataResolver().resolveSingle((Object)criteria)).map(e -> e.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol")).orElse(null);
    }

    @Override
    public List<EntityDescriptor> getIdentityProviders() throws ResolverException {
        ArrayList<EntityDescriptor> list = new ArrayList<EntityDescriptor>();
        Iterable<EntityDescriptor> it = this.iterator(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        it.forEach(list::add);
        return list;
    }

    @Override
    public List<EntityDescriptor> getServiceProviders() throws ResolverException {
        ArrayList<EntityDescriptor> list = new ArrayList<EntityDescriptor>();
        Iterable<EntityDescriptor> it = this.iterator(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        it.forEach(list::add);
        return list;
    }

    private synchronized void setMetadata(XMLObject metadata) {
        this.metadata = metadata;
        this.downloadTime = Instant.now();
    }

    protected final void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            this.createMetadataResolver(this.requireValidMetadata, this.failFastInitialization, this.createFilter());
        }
        catch (ResolverException e) {
            throw new ComponentInitializationException((Exception)((Object)e));
        }
        this.initializeMetadataResolver();
    }

    protected MetadataFilter createFilter() {
        ArrayList<Object> filters = new ArrayList<Object>();
        if (this.signatureVerificationCertificates != null && !this.signatureVerificationCertificates.isEmpty()) {
            StaticCredentialResolver credentialResolver = new StaticCredentialResolver(this.signatureVerificationCertificates.stream().map(c -> new BasicX509Credential(c)).collect(Collectors.toList()));
            BasicProviderKeyInfoCredentialResolver basicProviderKeyInfoCredentialResolver = new BasicProviderKeyInfoCredentialResolver(Arrays.asList(new RSAKeyValueProvider(), new InlineX509DataProvider(), new DSAKeyValueProvider(), new DEREncodedKeyValueProvider()));
            ExplicitKeySignatureTrustEngine trustEngine = new ExplicitKeySignatureTrustEngine((CredentialResolver)credentialResolver, (KeyInfoCredentialResolver)basicProviderKeyInfoCredentialResolver);
            filters.add(new SignatureValidationFilter((SignatureTrustEngine)trustEngine));
        }
        if (this.performSchemaValidation) {
            filters.add(new SchemaValidationFilter(new SAMLSchemaBuilder(SAMLSchemaBuilder.SAML1Version.SAML_11)));
        }
        if (this.inclusionPredicates != null) {
            for (Predicate<EntityDescriptor> predicate : this.inclusionPredicates) {
                filters.add(new PredicateFilter(PredicateFilter.Direction.INCLUDE, predicate));
            }
        }
        if (this.exclusionPredicates != null) {
            for (Predicate predicate : this.exclusionPredicates) {
                filters.add(new PredicateFilter(PredicateFilter.Direction.EXCLUDE, predicate));
            }
        }
        filters.add((metadata, ctx) -> {
            this.setMetadata(metadata);
            return metadata;
        });
        if (filters.size() == 1) {
            return (MetadataFilter)filters.get(0);
        }
        MetadataFilterChain chain = new MetadataFilterChain();
        chain.setFilters(filters);
        return chain;
    }

    protected void doDestroy() {
        super.doDestroy();
        this.destroyMetadataResolver();
    }

    protected abstract void createMetadataResolver(boolean var1, boolean var2, MetadataFilter var3) throws ResolverException;

    protected abstract void initializeMetadataResolver() throws ComponentInitializationException;

    protected abstract void destroyMetadataResolver();

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireValidMetadata = requireValidMetadata;
    }

    public void setFailFastInitialization(boolean failFast) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.failFastInitialization = failFast;
    }

    public void setSignatureVerificationCertificate(X509Certificate signatureVerificationCertificate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signatureVerificationCertificates = Collections.singletonList(signatureVerificationCertificate);
    }

    public void setSignatureVerificationCertificates(List<X509Certificate> signatureVerificationCertificates) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signatureVerificationCertificates = signatureVerificationCertificates;
    }

    public List<X509Certificate> getSignatureVerificationCertificates() {
        return this.signatureVerificationCertificates;
    }

    public void setPerformSchemaValidation(boolean performSchemaValidation) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.performSchemaValidation = performSchemaValidation;
    }

    public void setInclusionPredicates(List<Predicate<EntityDescriptor>> inclusionPredicates) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.inclusionPredicates = inclusionPredicates;
    }

    public void setExclusionPredicates(List<Predicate<EntityDescriptor>> exclusionPredicates) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.exclusionPredicates = exclusionPredicates;
    }

    protected static class EntityDescriptorIterator
    implements Iterator<EntityDescriptor>,
    Iterable<EntityDescriptor> {
        private Iterator<EntityDescriptor> iterator = null;

        public EntityDescriptorIterator(XMLObject metadata) {
            this(metadata, null);
        }

        public EntityDescriptorIterator(XMLObject metadata, QName role) {
            if (metadata == null) {
                return;
            }
            if (metadata instanceof EntityDescriptor) {
                this.iterator = Collections.singletonList((EntityDescriptor)metadata).iterator();
            } else if (metadata instanceof EntitiesDescriptor) {
                List<EntityDescriptor> edList = EntityDescriptorIterator.setup((EntitiesDescriptor)metadata, role);
                this.iterator = edList.iterator();
            } else {
                throw new IllegalArgumentException("Expected EntityDescriptor or EntitiesDescriptor");
            }
        }

        private static List<EntityDescriptor> setup(EntitiesDescriptor entitiesDescriptor, QName role) {
            ArrayList<EntityDescriptor> edList = new ArrayList<EntityDescriptor>();
            entitiesDescriptor.getEntityDescriptors().stream().filter(EntityDescriptorIterator.filterRole(role)).forEach(edList::add);
            for (EntitiesDescriptor ed : entitiesDescriptor.getEntitiesDescriptors()) {
                edList.addAll(EntityDescriptorIterator.setup(ed, role));
            }
            return edList;
        }

        public static Predicate<EntityDescriptor> filterRole(QName role) {
            return e -> role == null || !e.getRoleDescriptors(role).isEmpty();
        }

        @Override
        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        @Override
        public EntityDescriptor next() {
            if (this.iterator != null) {
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        @Nonnull
        public Iterator<EntityDescriptor> iterator() {
            return this;
        }
    }
}

