/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.security.impl.RandomIdentifierGenerationStrategy;
import org.apache.commons.lang3.Validate;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.CompositeMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import se.litsec.opensaml.saml2.metadata.provider.MetadataProvider;

public class CompositeMetadataProvider
extends AbstractMetadataProvider {
    private Logger log = LoggerFactory.getLogger(CompositeMetadataProvider.class);
    private CompositeMetadataResolverEx metadataResolver;
    private List<MetadataProvider> metadataProviders;
    private String id;
    private Instant initTime;
    private EntitiesDescriptor compositeMetadata;
    private Instant compositeMetadataCreationTime;
    private RandomIdentifierGenerationStrategy idGenerator = new RandomIdentifierGenerationStrategy(20);
    private List<String> destroyList = new ArrayList<String>();

    public CompositeMetadataProvider(String id, List<MetadataProvider> metadataProviders) {
        Validate.notNull((Object)id, (String)"id must not be null", (Object[])new Object[0]);
        Validate.notNull(metadataProviders, (String)"metadataProviders must not be null", (Object[])new Object[0]);
        this.id = id;
        this.metadataProviders = metadataProviders;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Override
    public synchronized XMLObject getMetadata() {
        Instant lastUpdate = this.getLastUpdate();
        if (lastUpdate == null) {
            this.log.debug("No metadata available for provider '{}'", (Object)this.getID());
            return null;
        }
        if (this.compositeMetadata == null || this.compositeMetadataCreationTime.isBefore(lastUpdate)) {
            this.collectMetadata();
        }
        return this.compositeMetadata;
    }

    private synchronized void collectMetadata() {
        this.log.debug("Collecting composite metadata for {} ...", (Object)this.getID());
        ArrayList<String> entityIds = new ArrayList<String>();
        EntitiesDescriptor metadata = (EntitiesDescriptor)XMLObjectSupport.buildXMLObject((QName)EntitiesDescriptor.DEFAULT_ELEMENT_NAME);
        metadata.setName(this.getID());
        metadata.setID("metadata_" + this.idGenerator.generateIdentifier(true));
        for (MetadataProvider provider : this.metadataProviders) {
            for (EntityDescriptor ed : provider.iterator()) {
                if (entityIds.contains(ed.getEntityID())) {
                    this.log.warn("EntityDescriptor for '{}' already exists in metadata. Entry read from provider '{}' will be ignored.", (Object)ed.getEntityID(), (Object)provider.getID());
                    continue;
                }
                try {
                    EntityDescriptor edCopy = (EntityDescriptor)XMLObjectSupport.cloneXMLObject((XMLObject)ed);
                    edCopy.setSignature(null);
                    edCopy.setCacheDuration(null);
                    edCopy.setValidUntil(null);
                    metadata.getEntityDescriptors().add(edCopy);
                    entityIds.add(edCopy.getEntityID());
                    this.log.trace("EntityDescriptor '{}' added to composite metadata", (Object)edCopy.getEntityID());
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error copying EntityDescriptor '{}' ({}), entry will not be included in metadata");
                }
            }
        }
        this.compositeMetadataCreationTime = Instant.now();
        this.compositeMetadata = metadata;
        this.log.info("Composite metadata for {} collected and compiled into EntitiesDescriptor", (Object)this.getID());
    }

    @Override
    public Instant getLastUpdate() {
        return Optional.ofNullable(this.metadataResolver.getLastUpdate()).orElse(this.initTime);
    }

    @Override
    protected void createMetadataResolver(boolean requireValidMetadata, boolean failFastInitialization, MetadataFilter filter) throws ResolverException {
        this.metadataResolver = new CompositeMetadataResolverEx();
        this.metadataResolver.setId(this.id);
    }

    @Override
    protected MetadataFilter createFilter() {
        return null;
    }

    @Override
    protected void initializeMetadataResolver() throws ComponentInitializationException {
        this.log.debug("Initializing CompositeMetadataProvider ...");
        for (MetadataProvider p : this.metadataProviders) {
            String id = p.getID();
            if (p.isInitialized()) {
                this.log.debug("Underlying provider ({}) has already been initialized", (Object)id);
                continue;
            }
            this.log.trace("Initializing underlying provider ({}) ...", (Object)id);
            p.initialize();
            this.destroyList.add(id);
            this.log.debug("Underlying provider ({}) successfully initialized", (Object)id);
        }
        this.initTime = Instant.now();
        List resolvers = this.metadataProviders.stream().map(MetadataProvider::getMetadataResolver).collect(Collectors.toList());
        if (resolvers.isEmpty()) {
            this.log.warn("No metadata sources installed for CompositeMetadataProvider '{}'", (Object)this.getID());
        }
        try {
            this.metadataResolver.setResolvers(resolvers);
        }
        catch (ResolverException e) {
            throw new ComponentInitializationException("Failed to install resolvers", (Exception)((Object)e));
        }
        this.metadataResolver.initialize();
        this.log.debug("CompositeMetadataProvider successfully initialized");
    }

    @Override
    protected void destroyMetadataResolver() {
        for (MetadataProvider p : this.metadataProviders) {
            String id = p.getID();
            try {
                if (!this.destroyList.contains(id) || !p.isInitialized() || p.isDestroyed()) continue;
                p.destroy();
            }
            catch (Exception e) {
                this.log.error("Error while destroying underlying provider ({})", (Object)id, (Object)e);
            }
        }
        if (this.metadataResolver != null) {
            this.metadataResolver.destroy();
        }
    }

    @Override
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new UnsupportedOperationException("Cannot configure 'requireValidMetadata' for a CompositeMetadataResolver");
    }

    @Override
    public void setFailFastInitialization(boolean failFast) {
        throw new UnsupportedOperationException("Cannot configure 'failFastInitialization' for a CompositeMetadataResolver");
    }

    @Override
    public void setInclusionPredicates(List<Predicate<EntityDescriptor>> inclusionPredicates) {
        throw new UnsupportedOperationException("Cannot configure 'inclusionPredicates' for a CompositeMetadataResolver");
    }

    @Override
    public void setExclusionPredicates(List<Predicate<EntityDescriptor>> exclusionPredicates) {
        throw new UnsupportedOperationException("Cannot configure 'exclusionPredicates' for a CompositeMetadataResolver");
    }

    @Override
    public void setSignatureVerificationCertificate(X509Certificate signatureVerificationCertificate) {
        throw new UnsupportedOperationException("Cannot configure 'signatureVerificationCertificate' for a CompositeMetadataResolver");
    }

    @Override
    public void setPerformSchemaValidation(boolean performSchemaValidation) {
        throw new UnsupportedOperationException("Cannot configure 'performSchemaValidation' for a CompositeMetadataResolver");
    }

    private static class CompositeMetadataResolverEx
    extends CompositeMetadataResolver {
        private CompositeMetadataResolverEx() {
        }

        public void setId(@Nonnull String componentId) {
            super.setId(componentId);
        }
    }
}

