/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.io.File;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang3.Validate;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import se.litsec.opensaml.saml2.metadata.provider.AbstractMetadataProvider;

public class FilesystemMetadataProvider
extends AbstractMetadataProvider {
    private FilesystemMetadataResolver metadataResolver;
    private File metadataSource;

    public FilesystemMetadataProvider(File metadataFile) {
        Validate.notNull((Object)metadataFile, (String)"metadataFile must not be null", (Object[])new Object[0]);
        this.metadataSource = metadataFile;
    }

    @Override
    public String getID() {
        return this.metadataSource.getName();
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Override
    protected void createMetadataResolver(boolean requireValidMetadata, boolean failFastInitialization, MetadataFilter filter) throws ResolverException {
        this.metadataResolver = new FilesystemMetadataResolver(this.metadataSource);
        this.metadataResolver.setId(this.getID());
        this.metadataResolver.setRequireValidMetadata(requireValidMetadata);
        this.metadataResolver.setFailFastInitialization(failFastInitialization);
        this.metadataResolver.setMetadataFilter(filter);
        this.metadataResolver.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
    }

    @Override
    protected void initializeMetadataResolver() throws ComponentInitializationException {
        this.metadataResolver.initialize();
    }

    @Override
    protected void destroyMetadataResolver() {
        if (this.metadataResolver != null) {
            this.metadataResolver.destroy();
        }
    }
}

