/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.httpclient.TLSSocketFactoryBuilder;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.FileBackedHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.litsec.opensaml.saml2.metadata.provider.AbstractMetadataProvider;

public class HTTPMetadataProvider
extends AbstractMetadataProvider {
    private Logger log = LoggerFactory.getLogger(HTTPMetadataProvider.class);
    private HTTPMetadataResolver metadataResolver;

    public HTTPMetadataProvider(String metadataUrl, String backupFile) throws ResolverException {
        this(metadataUrl, backupFile, HTTPMetadataProvider.createDefaultHttpClient());
    }

    public HTTPMetadataProvider(String metadataUrl, String backupFile, HttpClient httpClient) throws ResolverException {
        Validate.notEmpty((CharSequence)metadataUrl, (String)"metadataUrl must be set", (Object[])new Object[0]);
        Validate.notNull((Object)httpClient, (String)"httpClient must not be null", (Object[])new Object[0]);
        this.metadataResolver = backupFile != null ? new FileBackedHTTPMetadataResolver(httpClient, metadataUrl, backupFile) : new HTTPMetadataResolver(httpClient, metadataUrl);
    }

    public static HttpClient createDefaultHttpClient() throws ResolverException {
        return HTTPMetadataProvider.createDefaultHttpClient(null, (HostnameVerifier)new NoopHostnameVerifier());
    }

    public static HttpClient createDefaultHttpClient(KeyStore trustKeyStore, HostnameVerifier hostnameVerifier) throws ResolverException {
        try {
            List<TrustManager> managers = null;
            if (trustKeyStore != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustKeyStore);
                managers = Arrays.asList(trustManagerFactory.getTrustManagers());
            } else {
                managers = Arrays.asList(HttpClientSupport.buildNoTrustX509TrustManager());
            }
            HostnameVerifier hnv = hostnameVerifier != null ? hostnameVerifier : new DefaultHostnameVerifier();
            HttpClientBuilder builder = new HttpClientBuilder();
            builder.setUseSystemProperties(true);
            builder.setTLSSocketFactory((LayeredConnectionSocketFactory)new TLSSocketFactoryBuilder().setHostnameVerifier(hnv).setTrustManagers(managers).build());
            return builder.buildClient();
        }
        catch (Exception e) {
            throw new ResolverException("Failed to initialize HttpClient", e);
        }
    }

    @Override
    public String getID() {
        return this.metadataResolver.getMetadataURI();
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Override
    protected void createMetadataResolver(boolean requireValidMetadata, boolean failFastInitialization, MetadataFilter filter) throws ResolverException {
        this.metadataResolver.setId(this.getID());
        this.metadataResolver.setFailFastInitialization(failFastInitialization);
        this.metadataResolver.setRequireValidMetadata(requireValidMetadata);
        this.metadataResolver.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
        this.metadataResolver.setMetadataFilter(filter);
    }

    @Override
    protected void initializeMetadataResolver() throws ComponentInitializationException {
        String url = this.metadataResolver.getMetadataURI();
        if (url != null && url.startsWith("http:") && this.getSignatureVerificationCertificates() == null) {
            this.log.warn("Metadata is downloaded using HTTP and signature verification is not configured - metadata cannot be trusted");
        }
        this.metadataResolver.initialize();
    }

    @Override
    protected void destroyMetadataResolver() {
        if (this.metadataResolver != null) {
            this.metadataResolver.destroy();
        }
    }
}

