/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.util.function.Predicate;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;

public class MetadataProviderPredicates {
    public static Predicate<EntityDescriptor> includeOnlyIDPs() {
        return MetadataProviderPredicates::isIDP;
    }

    public static Predicate<EntityDescriptor> includeOnlyIDPsAndMe(String entityID) {
        return e -> entityID.equals(e.getEntityID()) || MetadataProviderPredicates.isIDP(e);
    }

    public static Predicate<EntityDescriptor> includeOnlySPs() {
        return e -> !e.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).isEmpty();
    }

    public static Predicate<EntityDescriptor> includeOnlyUsableIdPs(EntityDescriptor sp, boolean includeMyself) {
        return e -> includeMyself && sp.getEntityID().equals(e.getEntityID()) || MetadataProviderPredicates.isIDP(e) && MetadataProviderPredicates.isMatchingIDP(sp, e);
    }

    public static boolean isIDP(EntityDescriptor ed) {
        return !ed.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).isEmpty();
    }

    public static boolean isSP(EntityDescriptor ed) {
        return !ed.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).isEmpty();
    }

    public static boolean isMatchingIDP(EntityDescriptor sp, EntityDescriptor idp) {
        return true;
    }

    private MetadataProviderPredicates() {
    }
}

