/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import java.util.ArrayList;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.apache.commons.lang3.Validate;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import se.litsec.opensaml.saml2.metadata.provider.AbstractMetadataProvider;

public class ProxyMetadataProvider
extends AbstractMetadataProvider {
    private AbstractMetadataResolver metadataResolver;

    public ProxyMetadataProvider(MetadataResolver metadataResolver) {
        Validate.notNull((Object)metadataResolver, (String)"metadataResolver must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)AbstractMetadataResolver.class.isInstance(metadataResolver), (String)"Supplied metadata resolver must extend AbstractMetadataResolver", (Object[])new Object[0]);
        this.metadataResolver = (AbstractMetadataResolver)metadataResolver;
    }

    @Override
    public String getID() {
        return this.metadataResolver.getId();
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Override
    protected void createMetadataResolver(boolean requireValidMetadata, boolean failFastInitialization, MetadataFilter filter) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolver.setRequireValidMetadata(requireValidMetadata);
        this.metadataResolver.setFailFastInitialization(failFastInitialization);
        MetadataFilter installedFilter = this.metadataResolver.getMetadataFilter();
        if (installedFilter == null) {
            this.metadataResolver.setMetadataFilter(filter);
        } else {
            ArrayList<MetadataFilter> chain = new ArrayList<MetadataFilter>();
            if (filter instanceof MetadataFilterChain) {
                chain.addAll(((MetadataFilterChain)installedFilter).getFilters());
            } else {
                chain.add(filter);
            }
            if (installedFilter instanceof MetadataFilterChain) {
                chain.addAll(((MetadataFilterChain)installedFilter).getFilters());
            } else {
                chain.add(installedFilter);
            }
            MetadataFilterChain newFilter = new MetadataFilterChain();
            newFilter.setFilters(chain);
            this.metadataResolver.setMetadataFilter((MetadataFilter)newFilter);
        }
    }

    @Override
    protected void initializeMetadataResolver() throws ComponentInitializationException {
        this.metadataResolver.initialize();
    }

    @Override
    protected void destroyMetadataResolver() {
        this.metadataResolver.destroy();
    }
}

