/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.saml2.metadata.provider;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.w3c.dom.Element;
import se.litsec.opensaml.saml2.metadata.provider.AbstractMetadataProvider;

public class StaticMetadataProvider
extends AbstractMetadataProvider {
    private DOMMetadataResolver metadataResolver;
    private Element element;
    private String id;

    public StaticMetadataProvider(Element element) {
        this.element = element;
    }

    public StaticMetadataProvider(EntityDescriptor entityDescriptor) throws MarshallingException {
        this.element = entityDescriptor.getDOM();
        if (this.element == null) {
            this.element = XMLObjectSupport.marshall((XMLObject)entityDescriptor);
        }
    }

    public StaticMetadataProvider(EntitiesDescriptor entitiesDescriptor) throws MarshallingException {
        this.element = entitiesDescriptor.getDOM();
        if (this.element == null) {
            this.element = XMLObjectSupport.marshall((XMLObject)entitiesDescriptor);
        }
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.element.getAttribute("ID");
            if (this.id == null) {
                this.id = this.toString();
            }
        }
        return this.id;
    }

    @Override
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Override
    protected void createMetadataResolver(boolean requireValidMetadata, boolean failFastInitialization, MetadataFilter filter) {
        this.metadataResolver = new DOMMetadataResolver(this.element);
        this.metadataResolver.setRequireValidMetadata(requireValidMetadata);
        this.metadataResolver.setFailFastInitialization(failFastInitialization);
        this.metadataResolver.setMetadataFilter(filter);
        this.metadataResolver.setId(this.getID());
    }

    @Override
    protected void initializeMetadataResolver() throws ComponentInitializationException {
        this.metadataResolver.initialize();
    }

    @Override
    protected void destroyMetadataResolver() {
        if (this.metadataResolver != null) {
            this.metadataResolver.destroy();
        }
    }
}

