/*
 * Decompiled with CFR 0.152.
 */
package se.litsec.opensaml.utils.spring;

import java.security.KeyStore;
import java.util.Arrays;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

@Deprecated(forRemoval=true)
public class KeyStoreFactoryBean
extends AbstractFactoryBean<KeyStore> {
    protected Resource storeLocation;
    protected char[] storePassword;
    protected String storeType;

    public KeyStoreFactoryBean(Resource storeLocation, char[] storePassword) {
        this(storeLocation, storePassword, KeyStore.getDefaultType());
    }

    public KeyStoreFactoryBean(Resource storeLocation, char[] storePassword, String storeType) {
        this.storeLocation = storeLocation;
        this.storePassword = storePassword != null ? Arrays.copyOf(storePassword, storePassword.length) : new char[]{};
        this.storeType = storeType;
    }

    protected KeyStore createInstance() throws Exception {
        try {
            KeyStore keystore = KeyStore.getInstance(this.storeType);
            keystore.load(this.storeLocation.getInputStream(), this.storePassword);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        finally {
            if (this.isSingleton()) {
                Arrays.fill(this.storePassword, '\u0000');
            }
        }
    }

    public Class<?> getObjectType() {
        return KeyStore.class;
    }

    public void destroy() throws Exception {
        super.destroy();
        Arrays.fill(this.storePassword, '\u0000');
    }
}

