/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.fx;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.VBox;
import se.llbit.fx.ToolPane;
import se.llbit.fx.ToolTab;
import se.llbit.fx.ToolTabSkin;

class ToolPaneSkin
extends SkinBase<ToolPane> {
    private final ScrollPane scrollPane;
    private VBox content = new VBox();
    private Map<ToolTab, ToolTabSkin> tabs = new IdentityHashMap<ToolTab, ToolTabSkin>();

    ToolPaneSkin(ToolPane control) {
        super((Control)control);
        this.scrollPane = new ScrollPane((Node)this.content);
        this.content.setFillWidth(true);
        this.content.setPrefWidth(-1.0);
        this.content.setMaxWidth(Double.MAX_VALUE);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.getChildren().add((Object)this.scrollPane);
        for (ToolTab tab : control.getTabs()) {
            this.addTab(tab, -1);
        }
        control.getTabs().addListener(change -> {
            ObservableList<ToolTab> tabs = control.getTabs();
            while (change.next()) {
                if (change.wasPermutated()) {
                    ArrayList<Object> permuted = new ArrayList<Object>(change.getTo() - change.getFrom() + 1);
                    for (int i = change.getFrom(); i <= change.getTo(); ++i) {
                        permuted.add(tabs.get(i));
                    }
                    for (ToolTab toolTab : permuted) {
                        this.removeTab(toolTab);
                    }
                    for (int i = 0; i < permuted.size(); ++i) {
                        this.addTab((ToolTab)permuted.get(i), change.getFrom() + i);
                    }
                }
                if (change.wasAdded()) {
                    for (ToolTab tab : change.getAddedSubList()) {
                        this.addTab(tab, -1);
                    }
                }
                if (!change.wasRemoved()) continue;
                for (ToolTab tab : change.getRemoved()) {
                    this.removeTab(tab);
                }
            }
        });
    }

    private void removeTab(ToolTab tab) {
        this.content.getChildren().remove((Object)this.tabs.get(tab));
        this.tabs.remove(tab);
    }

    private void addTab(ToolTab tab, int offset) {
        ToolTabSkin skin = new ToolTabSkin(tab);
        this.tabs.put(tab, skin);
        if (offset >= 0) {
            this.content.getChildren().add(offset, (Object)skin);
        } else {
            this.content.getChildren().add((Object)skin);
        }
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.scrollPane.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.scrollPane.minWidth(height) + leftInset + rightInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.scrollPane.minHeight(width) + topInset + bottomInset;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.scrollPane.prefWidth(height) + leftInset + rightInset + 30.0;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.scrollPane.prefHeight(width) + topInset + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.scrollPane.maxWidth(height) + leftInset + rightInset;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.scrollPane.maxHeight(width) + topInset + bottomInset;
    }
}

