/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.fx;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import se.llbit.fx.ToolTab;

public class ToolTabSkin
extends StackPane {
    private final Node content;
    private final ToggleButton header;
    private final ToolTab tab;

    public ToolTabSkin(ToolTab tab) {
        this.tab = tab;
        this.header = new ToggleButton(tab.getTitle());
        this.header.setTextAlignment(TextAlignment.LEFT);
        this.header.setAlignment(Pos.BASELINE_LEFT);
        this.header.setMaxWidth(Double.MAX_VALUE);
        this.header.setStyle("-fx-background-radius: 0");
        this.setPrefWidth(Double.MAX_VALUE);
        this.setMaxWidth(Double.MAX_VALUE);
        this.header.setSelected(tab.getSelected());
        this.header.selectedProperty().addListener((observable, oldValue, selected) -> tab.setSelected((boolean)selected));
        this.content = tab.getContent();
        this.content.setVisible(tab.getSelected());
        this.getChildren().addAll((Object[])new Node[]{this.header, this.content});
        tab.selectedProperty().addListener((observable, prev, selected) -> {
            this.content.setVisible(selected.booleanValue());
            this.requestLayout();
        });
        this.setPrefWidth(-1.0);
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        this.header.resizeRelocate(0.0, 0.0, w, this.header.prefHeight(w));
        this.content.resizeRelocate(0.0, this.header.prefHeight(-1.0), w, this.content.prefHeight(w));
    }

    protected double computePrefWidth(double height) {
        return this.snapSize(Math.max(this.header.prefWidth(-1.0), this.content.prefWidth(-1.0)));
    }

    protected double computePrefHeight(double width) {
        double height = this.header.prefHeight(-1.0);
        if (this.tab.getSelected()) {
            height += this.content.prefHeight(-1.0);
        }
        return this.snapSize(height);
    }

    protected double computeMinWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computeMaxWidth(double height) {
        return this.computePrefWidth(height);
    }

    protected double computeMaxHeight(double width) {
        return this.computePrefHeight(width);
    }
}

