/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.library;

import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.SavedTrack;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;

public class GetUsersSavedTracksRequest
extends AbstractDataRequest {
    private GetUsersSavedTracksRequest(Builder builder) {
        super(builder);
    }

    public Paging<SavedTrack> execute() throws IOException, SpotifyWebApiException {
        return new SavedTrack.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        @Override
        public GetUsersSavedTracksRequest build() {
            this.setPath("/v1/me/tracks");
            return new GetUsersSavedTracksRequest(this);
        }
    }
}

