/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.wrapper.spotify.IHttpManager;
import com.wrapper.spotify.SpotifyApi;
import com.wrapper.spotify.SpotifyApiThreading;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.requests.IRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;

public abstract class AbstractRequest<T>
implements IRequest<T> {
    private final IHttpManager httpManager;
    private final List<Header> headers;
    private final ContentType contentType;
    private final List<NameValuePair> bodyParameters;
    private URI uri;
    private HttpEntity body;

    protected AbstractRequest(Builder<T, ?> builder) {
        assert (builder != null);
        assert (((Builder)builder).path != null);
        assert (!((Builder)builder).path.equals(""));
        this.httpManager = ((Builder)builder).httpManager;
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(((Builder)builder).scheme).setHost(((Builder)builder).host).setPort(((Builder)builder).port.intValue()).setPath(((Builder)builder).path);
        if (((Builder)builder).queryParameters.size() > 0) {
            uriBuilder.setParameters(((Builder)builder).queryParameters);
        }
        try {
            this.uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            SpotifyApi.LOGGER.log(Level.SEVERE, e.getMessage());
        }
        this.headers = ((Builder)builder).headers;
        this.contentType = ((Builder)builder).contentType;
        this.body = ((Builder)builder).body;
        this.bodyParameters = ((Builder)builder).bodyParameters;
    }

    @Override
    public CompletableFuture<T> executeAsync() {
        return SpotifyApiThreading.executeAsync(this::execute);
    }

    public void initializeBody() {
        if (this.body == null && this.contentType != null) {
            switch (this.contentType.getMimeType()) {
                case "application/json": {
                    this.body = new StringEntity(this.bodyParametersToJson(this.bodyParameters), ContentType.APPLICATION_JSON);
                    break;
                }
                case "application/x-www-form-urlencoded": {
                    this.body = new UrlEncodedFormEntity(this.bodyParameters);
                }
            }
        }
    }

    public String bodyParametersToJson(List<NameValuePair> bodyParameters) {
        JsonObject jsonObject = new JsonObject();
        for (NameValuePair nameValuePair : bodyParameters) {
            JsonElement jsonElement;
            try {
                jsonElement = JsonParser.parseString((String)nameValuePair.getValue());
            }
            catch (JsonSyntaxException e) {
                jsonElement = new JsonPrimitive(nameValuePair.getValue());
            }
            jsonObject.add(nameValuePair.getName(), jsonElement);
        }
        return jsonObject.toString();
    }

    @Override
    public String getJson() throws IOException, SpotifyWebApiException, ParseException {
        String json = this.httpManager.get(this.uri, this.headers.toArray(new Header[0]));
        if (json == null || json.equals("")) {
            return null;
        }
        return json;
    }

    @Override
    public String postJson() throws IOException, SpotifyWebApiException, ParseException {
        this.initializeBody();
        String json = this.httpManager.post(this.uri, this.headers.toArray(new Header[0]), this.body);
        if (json == null || json.equals("")) {
            return null;
        }
        return json;
    }

    @Override
    public String putJson() throws IOException, SpotifyWebApiException, ParseException {
        this.initializeBody();
        String json = this.httpManager.put(this.uri, this.headers.toArray(new Header[0]), this.body);
        if (json == null || json.equals("")) {
            return null;
        }
        return json;
    }

    @Override
    public String deleteJson() throws IOException, SpotifyWebApiException, ParseException {
        this.initializeBody();
        String json = this.httpManager.delete(this.uri, this.headers.toArray(new Header[0]), this.body);
        if (json == null || json.equals("")) {
            return null;
        }
        return json;
    }

    @Override
    public IHttpManager getHttpManager() {
        return this.httpManager;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public List<Header> getHeaders() {
        return this.headers;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public HttpEntity getBody() {
        return this.body;
    }

    @Override
    public List<NameValuePair> getBodyParameters() {
        return this.bodyParameters;
    }

    public static abstract class Builder<T, BT extends Builder<T, ?>>
    implements IRequest.Builder<T, BT> {
        private final List<NameValuePair> pathParameters = new ArrayList<NameValuePair>();
        private final List<NameValuePair> queryParameters = new ArrayList<NameValuePair>();
        private final List<Header> headers = new ArrayList<Header>();
        private final List<NameValuePair> bodyParameters = new ArrayList<NameValuePair>();
        private IHttpManager httpManager = SpotifyApi.DEFAULT_HTTP_MANAGER;
        private String scheme = "https";
        private String host = "api.spotify.com";
        private Integer port = 443;
        private String path = null;
        private ContentType contentType = null;
        private HttpEntity body = null;

        protected Builder() {
        }

        @Override
        public BT setHttpManager(IHttpManager httpManager) {
            assert (httpManager != null);
            this.httpManager = httpManager;
            return this.self();
        }

        @Override
        public BT setScheme(String scheme) {
            assert (scheme != null);
            assert (!scheme.equals(""));
            this.scheme = scheme;
            return this.self();
        }

        @Override
        public BT setHost(String host) {
            assert (host != null);
            assert (!this.scheme.equals(""));
            this.host = host;
            return this.self();
        }

        @Override
        public BT setPort(Integer port) {
            assert (port != null);
            assert (port >= 0);
            this.port = port;
            return this.self();
        }

        @Override
        public BT setPath(String path) {
            assert (path != null);
            assert (!path.equals(""));
            String builtPath = path;
            for (NameValuePair nameValuePair : this.pathParameters) {
                String key = "\\{" + nameValuePair.getName() + "\\}";
                builtPath = builtPath.replaceAll(key, nameValuePair.getValue());
            }
            this.path = builtPath;
            return this.self();
        }

        @Override
        public BT setPathParameter(String name, String value) {
            assert (name != null && value != null);
            assert (!name.equals("") && !value.equals(""));
            this.listAddOnce(this.pathParameters, (NameValuePair)new BasicNameValuePair(name, value));
            return this.self();
        }

        @Override
        public BT setDefaults(IHttpManager httpManager, String scheme, String host, Integer port) {
            this.setHttpManager(httpManager);
            this.setScheme(scheme);
            this.setHost(host);
            this.setPort(port);
            return this.self();
        }

        @Override
        public <X> BT setQueryParameter(String name, X value) {
            assert (name != null);
            assert (!name.equals(""));
            assert (value != null);
            this.listAddOnce(this.queryParameters, (NameValuePair)new BasicNameValuePair(name, String.valueOf(value)));
            return this.self();
        }

        @Override
        public <X> BT setHeader(String name, X value) {
            assert (name != null);
            assert (!name.equals(""));
            assert (value != null);
            this.listAddOnce(this.headers, (Header)new BasicHeader(name, (Object)String.valueOf(value)));
            return this.self();
        }

        @Override
        public BT setContentType(ContentType contentType) {
            this.contentType = contentType;
            this.setHeader("Content-Type", contentType.getMimeType());
            return this.self();
        }

        @Override
        public BT setBody(HttpEntity httpEntity) {
            this.body = httpEntity;
            return this.self();
        }

        @Override
        public <X> BT setBodyParameter(String name, X value) {
            assert (name != null);
            assert (!name.equals(""));
            assert (value != null);
            this.listAddOnce(this.bodyParameters, (NameValuePair)new BasicNameValuePair(name, String.valueOf(value)));
            return this.self();
        }

        private void listAddOnce(List<NameValuePair> nameValuePairs, NameValuePair newNameValuePair) {
            nameValuePairs.removeAll(nameValuePairs.stream().filter(nameValuePair -> nameValuePair.getName().equals(newNameValuePair.getName())).collect(Collectors.toList()));
            nameValuePairs.add(newNameValuePair);
        }

        private void listAddOnce(List<Header> headers, Header newHeader) {
            headers.removeAll(headers.stream().filter(header -> header.getName().equals(newHeader.getName())).collect(Collectors.toList()));
            headers.add(newHeader);
        }

        protected abstract BT self();
    }
}

