/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.authorization.authorization_code;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.credentials.AuthorizationCodeCredentials;
import com.wrapper.spotify.requests.authorization.AbstractAuthorizationRequest;
import java.io.IOException;
import java.net.URI;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class AuthorizationCodeRequest
extends AbstractAuthorizationRequest<AuthorizationCodeCredentials> {
    private AuthorizationCodeRequest(Builder builder) {
        super(builder);
    }

    @Override
    public AuthorizationCodeCredentials execute() throws IOException, SpotifyWebApiException, ParseException {
        return (AuthorizationCodeCredentials)new AuthorizationCodeCredentials.JsonUtil().createModelObject(this.postJson());
    }

    public static final class Builder
    extends AbstractAuthorizationRequest.Builder<AuthorizationCodeCredentials, Builder> {
        public Builder(String clientId, String clientSecret) {
            super(clientId, clientSecret);
        }

        public Builder grant_type(String grant_type) {
            assert (grant_type != null);
            assert (grant_type.equals("authorization_code"));
            return (Builder)this.setBodyParameter("grant_type", grant_type);
        }

        public Builder code(String code) {
            assert (code != null);
            assert (!code.equals(""));
            return (Builder)this.setBodyParameter("code", code);
        }

        public Builder redirect_uri(URI redirect_uri) {
            assert (redirect_uri != null);
            return (Builder)this.setBodyParameter("redirect_uri", redirect_uri.toString());
        }

        public AuthorizationCodeRequest build() {
            this.setContentType(ContentType.APPLICATION_FORM_URLENCODED);
            this.setHost("accounts.spotify.com");
            this.setPort(443);
            this.setScheme("https");
            this.setPath("/api/token");
            return new AuthorizationCodeRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

