/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.authorization.client_credentials;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.credentials.ClientCredentials;
import com.wrapper.spotify.requests.authorization.AbstractAuthorizationRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class ClientCredentialsRequest
extends AbstractAuthorizationRequest<ClientCredentials> {
    public ClientCredentialsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public ClientCredentials execute() throws IOException, SpotifyWebApiException, ParseException {
        return (ClientCredentials)new ClientCredentials.JsonUtil().createModelObject(this.postJson());
    }

    public static final class Builder
    extends AbstractAuthorizationRequest.Builder<ClientCredentials, Builder> {
        public Builder(String clientId, String clientSecret) {
            super(clientId, clientSecret);
        }

        public Builder grant_type(String grant_type) {
            assert (grant_type != null);
            assert (grant_type.equals("client_credentials"));
            return (Builder)this.setBodyParameter("grant_type", grant_type);
        }

        public ClientCredentialsRequest build() {
            this.setContentType(ContentType.APPLICATION_FORM_URLENCODED);
            this.setHost("accounts.spotify.com");
            this.setPort(443);
            this.setScheme("https");
            this.setPath("/api/token");
            return new ClientCredentialsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

