/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.artists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Track;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetArtistsTopTracksRequest
extends AbstractDataRequest<Track[]> {
    private GetArtistsTopTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Track[] execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Track[])new Track.JsonUtil().createModelObjectArray(this.getJson(), "tracks");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Track[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder id(String id) {
            assert (id != null);
            assert (!id.equals(""));
            return (Builder)this.setPathParameter("id", id);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", country);
        }

        public GetArtistsTopTracksRequest build() {
            this.setPath("/v1/artists/{id}/top-tracks");
            return new GetArtistsTopTracksRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

