/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.browse;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.LanguageCode;
import com.wrapper.spotify.SpotifyApi;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.special.FeaturedPlaylists;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import java.util.Date;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetListOfFeaturedPlaylistsRequest
extends AbstractDataRequest<FeaturedPlaylists> {
    private GetListOfFeaturedPlaylistsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public FeaturedPlaylists execute() throws IOException, SpotifyWebApiException, ParseException {
        return (FeaturedPlaylists)new FeaturedPlaylists.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<FeaturedPlaylists, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder locale(String locale) {
            assert (locale != null);
            assert (locale.contains("_"));
            String[] localeParts = locale.split("_");
            assert (localeParts.length == 2);
            assert (LanguageCode.getByCode((String)localeParts[0]) != null);
            assert (CountryCode.getByCode((String)localeParts[1]) != null);
            return (Builder)this.setQueryParameter("locale", locale);
        }

        public Builder country(CountryCode country) {
            assert (country != null);
            return (Builder)this.setQueryParameter("country", country);
        }

        public Builder timestamp(Date timestamp) {
            assert (timestamp != null);
            return (Builder)this.setQueryParameter("timestamp", SpotifyApi.formatDefaultDate(timestamp));
        }

        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetListOfFeaturedPlaylistsRequest build() {
            this.setPath("/v1/browse/featured-playlists");
            return new GetListOfFeaturedPlaylistsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

