/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.library;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.SavedShow;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetUsersSavedShowsRequest
extends AbstractDataRequest<Paging<SavedShow>> {
    private GetUsersSavedShowsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<SavedShow> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new SavedShow.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<SavedShow, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetUsersSavedShowsRequest build() {
            this.setPath("/v1/me/shows");
            return new GetUsersSavedShowsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

