/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.player;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.miscellaneous.CurrentlyPlayingContext;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetInformationAboutUsersCurrentPlaybackRequest
extends AbstractDataRequest<CurrentlyPlayingContext> {
    private GetInformationAboutUsersCurrentPlaybackRequest(Builder builder) {
        super(builder);
    }

    @Override
    public CurrentlyPlayingContext execute() throws IOException, SpotifyWebApiException, ParseException {
        return (CurrentlyPlayingContext)new CurrentlyPlayingContext.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<CurrentlyPlayingContext, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public Builder additionalTypes(String additionalTypes) {
            assert (additionalTypes != null);
            assert (additionalTypes.matches("((^|,)(episode|track))+$"));
            return (Builder)this.setQueryParameter("additional_types", additionalTypes);
        }

        public GetInformationAboutUsersCurrentPlaybackRequest build() {
            this.setPath("/v1/me/player");
            return new GetInformationAboutUsersCurrentPlaybackRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

