/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonArray;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.special.SnapshotResult;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class RemoveItemsFromPlaylistRequest
extends AbstractDataRequest<SnapshotResult> {
    private RemoveItemsFromPlaylistRequest(Builder builder) {
        super(builder);
    }

    @Override
    public SnapshotResult execute() throws IOException, SpotifyWebApiException, ParseException {
        return (SnapshotResult)new SnapshotResult.JsonUtil().createModelObject(this.deleteJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<SnapshotResult, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Deprecated
        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.equals(""));
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder tracks(JsonArray tracks) {
            assert (tracks != null);
            assert (!tracks.isJsonNull());
            assert (tracks.size() <= 100);
            return (Builder)this.setBodyParameter("tracks", tracks);
        }

        public Builder snapshotId(String snapshotId) {
            assert (snapshotId != null);
            assert (!snapshotId.equals(""));
            return (Builder)this.setBodyParameter("snapshot_id", snapshotId);
        }

        public RemoveItemsFromPlaylistRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/playlists/{playlist_id}/tracks");
            return new RemoveItemsFromPlaylistRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

