/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.search.simplified;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.AlbumSimplified;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class SearchAlbumsRequest
extends AbstractDataRequest<Paging<AlbumSimplified>> {
    private SearchAlbumsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<AlbumSimplified> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new AlbumSimplified.JsonUtil().createModelObjectPaging(this.getJson(), "albums");
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<AlbumSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder q(String q) {
            assert (q != null);
            assert (!q.equals(""));
            return (Builder)this.setQueryParameter("q", q);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset != null);
            assert (0 <= offset && offset <= 100000);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder includeExternal(String includeExternal) {
            assert (includeExternal != null);
            assert (includeExternal.matches("audio"));
            return (Builder)this.setQueryParameter("include_external", includeExternal);
        }

        public SearchAlbumsRequest build() {
            this.setPath("/v1/search");
            this.setQueryParameter("type", "album");
            return new SearchAlbumsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

