/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.shows;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.ShowSimplified;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetSeveralShowsRequest
extends AbstractDataRequest<ShowSimplified[]> {
    private GetSeveralShowsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public ShowSimplified[] execute() throws IOException, SpotifyWebApiException, ParseException {
        return (ShowSimplified[])new ShowSimplified.JsonUtil().createModelObjectArray(this.getJson(), "shows");
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<ShowSimplified[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder ids(String ids) {
            assert (ids != null);
            assert (ids.split(",").length <= 50);
            return (Builder)this.setQueryParameter("ids", ids);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetSeveralShowsRequest build() {
            this.setPath("/v1/shows");
            return new GetSeveralShowsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

