/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.shows;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.EpisodeSimplified;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.requests.data.AbstractDataPagingRequest;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetShowsEpisodesRequest
extends AbstractDataRequest<Paging<EpisodeSimplified>> {
    private GetShowsEpisodesRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<EpisodeSimplified> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new EpisodeSimplified.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<EpisodeSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder id(String id) {
            assert (id != null);
            assert (!id.equals(""));
            return (Builder)this.setPathParameter("id", id);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetShowsEpisodesRequest build() {
            this.setPath("/v1/shows/{id}/episodes");
            return new GetShowsEpisodesRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

