/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.wrapper.spotify.IHttpManager;
import com.wrapper.spotify.SpotifyApi;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.exceptions.detailed.BadGatewayException;
import com.wrapper.spotify.exceptions.detailed.BadRequestException;
import com.wrapper.spotify.exceptions.detailed.ForbiddenException;
import com.wrapper.spotify.exceptions.detailed.InternalServerErrorException;
import com.wrapper.spotify.exceptions.detailed.NotFoundException;
import com.wrapper.spotify.exceptions.detailed.ServiceUnavailableException;
import com.wrapper.spotify.exceptions.detailed.TooManyRequestsException;
import com.wrapper.spotify.exceptions.detailed.UnauthorizedException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingHttpClients;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;

public class SpotifyHttpManager
implements IHttpManager {
    private static final int DEFAULT_CACHE_MAX_ENTRIES = 1000;
    private static final int DEFAULT_CACHE_MAX_OBJECT_SIZE = 8192;
    private final CloseableHttpClient httpClient;
    private final CloseableHttpClient httpClientCaching;
    private final HttpHost proxy;
    private final UsernamePasswordCredentials proxyCredentials;
    private final Integer cacheMaxEntries;
    private final Integer cacheMaxObjectSize;
    private final Integer connectionRequestTimeout;
    private final Integer connectTimeout;
    private final Integer socketTimeout;

    public SpotifyHttpManager(Builder builder) {
        this.proxy = builder.proxy;
        this.proxyCredentials = builder.proxyCredentials;
        this.cacheMaxEntries = builder.cacheMaxEntries;
        this.cacheMaxObjectSize = builder.cacheMaxObjectSize;
        this.connectionRequestTimeout = builder.connectionRequestTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(this.cacheMaxEntries != null ? this.cacheMaxEntries : 1000).setMaxObjectSize(this.cacheMaxObjectSize != null ? (long)this.cacheMaxObjectSize.intValue() : 8192L).setSharedCache(false).build();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (this.proxy != null) {
            credentialsProvider.setCredentials(new AuthScope(null, this.proxy.getHostName(), this.proxy.getPort(), null, this.proxy.getSchemeName()), (Credentials)this.proxyCredentials);
        }
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("strict").setProxy(this.proxy).setConnectionRequestTimeout(builder.connectionRequestTimeout != null ? Timeout.ofMilliseconds((long)builder.connectionRequestTimeout.intValue()) : RequestConfig.DEFAULT.getConnectionRequestTimeout()).setConnectTimeout(builder.connectTimeout != null ? Timeout.ofMilliseconds((long)builder.connectTimeout.intValue()) : RequestConfig.DEFAULT.getConnectTimeout()).setResponseTimeout(builder.socketTimeout != null ? Timeout.ofMilliseconds((long)builder.socketTimeout.intValue()) : RequestConfig.DEFAULT.getResponseTimeout()).build();
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(requestConfig).disableContentCompression().build();
        this.httpClientCaching = CachingHttpClients.custom().setCacheConfig(cacheConfig).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultRequestConfig(requestConfig).disableContentCompression().build();
    }

    public static URI makeUri(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            SpotifyApi.LOGGER.log(Level.SEVERE, "URI Syntax Exception for \"" + uriString + "\"");
            return null;
        }
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public UsernamePasswordCredentials getProxyCredentials() {
        return this.proxyCredentials;
    }

    public Integer getCacheMaxEntries() {
        return this.cacheMaxEntries;
    }

    public Integer getCacheMaxObjectSize() {
        return this.cacheMaxObjectSize;
    }

    public Integer getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public String get(URI uri, Header[] headers) throws IOException, SpotifyWebApiException, ParseException {
        assert (uri != null);
        assert (!uri.toString().equals(""));
        HttpGet httpGet = new HttpGet(uri);
        httpGet.setHeaders(headers);
        String responseBody = this.getResponseBody(this.execute(this.httpClientCaching, (ClassicHttpRequest)httpGet));
        httpGet.reset();
        return responseBody;
    }

    @Override
    public String post(URI uri, Header[] headers, HttpEntity body) throws IOException, SpotifyWebApiException, ParseException {
        assert (uri != null);
        assert (!uri.toString().equals(""));
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeaders(headers);
        httpPost.setEntity(body);
        String responseBody = this.getResponseBody(this.execute(this.httpClient, (ClassicHttpRequest)httpPost));
        httpPost.reset();
        return responseBody;
    }

    @Override
    public String put(URI uri, Header[] headers, HttpEntity body) throws IOException, SpotifyWebApiException, ParseException {
        assert (uri != null);
        assert (!uri.toString().equals(""));
        HttpPut httpPut = new HttpPut(uri);
        httpPut.setHeaders(headers);
        httpPut.setEntity(body);
        String responseBody = this.getResponseBody(this.execute(this.httpClient, (ClassicHttpRequest)httpPut));
        httpPut.reset();
        return responseBody;
    }

    @Override
    public String delete(URI uri, Header[] headers, HttpEntity body) throws IOException, SpotifyWebApiException, ParseException {
        assert (uri != null);
        assert (!uri.toString().equals(""));
        HttpDelete httpDelete = new HttpDelete(uri);
        httpDelete.setHeaders(headers);
        httpDelete.setEntity(body);
        String responseBody = this.getResponseBody(this.execute(this.httpClient, (ClassicHttpRequest)httpDelete));
        httpDelete.reset();
        return responseBody;
    }

    private CloseableHttpResponse execute(CloseableHttpClient httpClient, ClassicHttpRequest method) throws IOException {
        HttpCacheContext context = HttpCacheContext.create();
        CloseableHttpResponse response = httpClient.execute(method, (HttpContext)context);
        try {
            CacheResponseStatus responseStatus = context.getCacheResponseStatus();
            if (responseStatus != null) {
                switch (responseStatus) {
                    case CACHE_HIT: {
                        SpotifyApi.LOGGER.log(Level.CONFIG, "A response was generated from the cache with no requests sent upstream");
                        break;
                    }
                    case CACHE_MODULE_RESPONSE: {
                        SpotifyApi.LOGGER.log(Level.CONFIG, "The response was generated directly by the caching module");
                        break;
                    }
                    case CACHE_MISS: {
                        SpotifyApi.LOGGER.log(Level.CONFIG, "The response came from an upstream server");
                        break;
                    }
                    case VALIDATED: {
                        SpotifyApi.LOGGER.log(Level.CONFIG, "The response was generated from the cache after validating the entry with the origin server");
                        break;
                    }
                    case FAILURE: {
                        SpotifyApi.LOGGER.log(Level.CONFIG, "The response came from an upstream server after a cache failure");
                    }
                }
            }
        }
        catch (Exception e) {
            SpotifyApi.LOGGER.log(Level.SEVERE, e.getMessage());
        }
        return response;
    }

    private String getResponseBody(CloseableHttpResponse httpResponse) throws IOException, SpotifyWebApiException, ParseException {
        String responseBody = httpResponse.getEntity() != null ? EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8") : null;
        String errorMessage = httpResponse.getReasonPhrase();
        SpotifyApi.LOGGER.log(Level.FINE, "The http response has body " + responseBody);
        if (responseBody != null && !responseBody.equals("")) {
            try {
                JsonObject jsonObject;
                JsonElement jsonElement = JsonParser.parseString((String)responseBody);
                if (jsonElement.isJsonObject() && (jsonObject = JsonParser.parseString((String)responseBody).getAsJsonObject()).has("error")) {
                    if (jsonObject.has("error_description")) {
                        errorMessage = jsonObject.get("error_description").getAsString();
                    } else if (jsonObject.get("error").isJsonObject() && jsonObject.getAsJsonObject("error").has("message")) {
                        errorMessage = jsonObject.getAsJsonObject("error").get("message").getAsString();
                    }
                }
            }
            catch (JsonSyntaxException jsonElement) {
                // empty catch block
            }
        }
        SpotifyApi.LOGGER.log(Level.FINE, "The http response has status code " + httpResponse.getCode());
        switch (httpResponse.getCode()) {
            case 400: {
                throw new BadRequestException(errorMessage);
            }
            case 401: {
                throw new UnauthorizedException(errorMessage);
            }
            case 403: {
                throw new ForbiddenException(errorMessage);
            }
            case 404: {
                throw new NotFoundException(errorMessage);
            }
            case 429: {
                Header header = httpResponse.getFirstHeader("Retry-After");
                if (header != null) {
                    throw new TooManyRequestsException(errorMessage, Integer.parseInt(header.getValue()));
                }
                throw new TooManyRequestsException(errorMessage);
            }
            case 500: {
                throw new InternalServerErrorException(errorMessage);
            }
            case 502: {
                throw new BadGatewayException(errorMessage);
            }
            case 503: {
                throw new ServiceUnavailableException(errorMessage);
            }
        }
        return responseBody;
    }

    public static class Builder {
        private HttpHost proxy;
        private UsernamePasswordCredentials proxyCredentials;
        private Integer cacheMaxEntries;
        private Integer cacheMaxObjectSize;
        private Integer connectionRequestTimeout;
        private Integer connectTimeout;
        private Integer socketTimeout;

        public Builder setProxy(HttpHost proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder setProxyCredentials(UsernamePasswordCredentials proxyCredentials) {
            this.proxyCredentials = proxyCredentials;
            return this;
        }

        public Builder setCacheMaxEntries(Integer cacheMaxEntries) {
            this.cacheMaxEntries = cacheMaxEntries;
            return this;
        }

        public Builder setCacheMaxObjectSize(Integer cacheMaxObjectSize) {
            this.cacheMaxObjectSize = cacheMaxObjectSize;
            return this;
        }

        public Builder setConnectionRequestTimeout(Integer connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public SpotifyHttpManager build() {
            return new SpotifyHttpManager(this);
        }
    }
}

