/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.model_objects.special;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import com.wrapper.spotify.model_objects.AbstractModelObject;
import com.wrapper.spotify.model_objects.specification.AlbumSimplified;
import com.wrapper.spotify.model_objects.specification.Artist;
import com.wrapper.spotify.model_objects.specification.EpisodeSimplified;
import com.wrapper.spotify.model_objects.specification.Paging;
import com.wrapper.spotify.model_objects.specification.PlaylistSimplified;
import com.wrapper.spotify.model_objects.specification.ShowSimplified;
import com.wrapper.spotify.model_objects.specification.Track;
import com.wrapper.spotify.requests.data.personalization.interfaces.IArtistTrackModelObject;
import com.wrapper.spotify.requests.data.search.interfaces.ISearchModelObject;

@JsonDeserialize(builder=Builder.class)
public class SearchResult
extends AbstractModelObject
implements IArtistTrackModelObject,
ISearchModelObject {
    private final Paging<AlbumSimplified> albums;
    private final Paging<Artist> artists;
    private final Paging<EpisodeSimplified> episodes;
    private final Paging<PlaylistSimplified> playlists;
    private final Paging<ShowSimplified> shows;
    private final Paging<Track> tracks;

    private SearchResult(Builder builder) {
        super(builder);
        this.albums = builder.albums;
        this.artists = builder.artists;
        this.episodes = builder.episodes;
        this.playlists = builder.playlists;
        this.shows = builder.shows;
        this.tracks = builder.tracks;
    }

    public Paging<AlbumSimplified> getAlbums() {
        return this.albums;
    }

    public Paging<Artist> getArtists() {
        return this.artists;
    }

    public Paging<EpisodeSimplified> getEpisodes() {
        return this.episodes;
    }

    public Paging<PlaylistSimplified> getPlaylists() {
        return this.playlists;
    }

    public Paging<ShowSimplified> getShows() {
        return this.shows;
    }

    public Paging<Track> getTracks() {
        return this.tracks;
    }

    @Override
    public String toString() {
        return "SearchResult(albums=" + this.albums + ", artists=" + this.artists + ", episodes=" + this.episodes + ", playlists=" + this.playlists + ", shows=" + this.shows + ", tracks=" + this.tracks + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<SearchResult> {
        @Override
        public SearchResult createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setAlbums(this.hasAndNotNull(jsonObject, "albums") ? new AlbumSimplified.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("albums")) : null).setArtists(this.hasAndNotNull(jsonObject, "artists") ? new Artist.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("artists")) : null).setEpisodes(this.hasAndNotNull(jsonObject, "episodes") ? new EpisodeSimplified.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("episodes")) : null).setPlaylists(this.hasAndNotNull(jsonObject, "playlists") ? new PlaylistSimplified.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("playlists")) : null).setShows(this.hasAndNotNull(jsonObject, "shows") ? new ShowSimplified.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("shows")) : null).setTracks(this.hasAndNotNull(jsonObject, "tracks") ? new Track.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("tracks")) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private Paging<AlbumSimplified> albums;
        private Paging<Artist> artists;
        private Paging<EpisodeSimplified> episodes;
        private Paging<PlaylistSimplified> playlists;
        private Paging<ShowSimplified> shows;
        private Paging<Track> tracks;

        public Builder setAlbums(Paging<AlbumSimplified> albums) {
            this.albums = albums;
            return this;
        }

        public Builder setArtists(Paging<Artist> artists) {
            this.artists = artists;
            return this;
        }

        public Builder setEpisodes(Paging<EpisodeSimplified> episodes) {
            this.episodes = episodes;
            return this;
        }

        public Builder setPlaylists(Paging<PlaylistSimplified> playlists) {
            this.playlists = playlists;
            return this;
        }

        public Builder setShows(Paging<ShowSimplified> shows) {
            this.shows = shows;
            return this;
        }

        public Builder setTracks(Paging<Track> tracks) {
            this.tracks = tracks;
            return this;
        }

        @Override
        public SearchResult build() {
            return new SearchResult(this);
        }
    }
}

