/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.episodes;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Episode;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetEpisodeRequest
extends AbstractDataRequest<Episode> {
    private GetEpisodeRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Episode execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Episode)new Episode.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Episode, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder id(String id) {
            assert (id != null);
            assert (!id.equals(""));
            return (Builder)this.setPathParameter("id", id);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetEpisodeRequest build() {
            this.setPath("/v1/episodes/{id}");
            return new GetEpisodeRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

