/*
 * Decompiled with CFR 0.152.
 */
package com.wrapper.spotify.requests.data.tracks;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import com.wrapper.spotify.exceptions.SpotifyWebApiException;
import com.wrapper.spotify.model_objects.specification.Track;
import com.wrapper.spotify.requests.data.AbstractDataRequest;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;

@JsonDeserialize(builder=Builder.class)
public class GetTrackRequest
extends AbstractDataRequest<Track> {
    private GetTrackRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Track execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Track)new Track.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Track, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder id(String id) {
            assert (id != null);
            assert (!id.equals(""));
            return (Builder)this.setPathParameter("id", id);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetTrackRequest build() {
            this.setPath("/v1/tracks/{id}");
            return new GetTrackRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

