/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.miscellaneous;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;

@JsonDeserialize(builder=Builder.class)
public class AudioAnalysisMeasure
extends AbstractModelObject {
    private final Float confidence;
    private final Float duration;
    private final Float start;

    private AudioAnalysisMeasure(Builder builder) {
        super(builder);
        this.confidence = builder.confidence;
        this.duration = builder.duration;
        this.start = builder.start;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public Float getDuration() {
        return this.duration;
    }

    public Float getStart() {
        return this.start;
    }

    @Override
    public String toString() {
        return "AudioAnalysisMeasure(confidence=" + this.confidence + ", duration=" + this.duration + ", start=" + this.start + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<AudioAnalysisMeasure> {
        @Override
        public AudioAnalysisMeasure createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setConfidence(this.hasAndNotNull(jsonObject, "confidence") ? Float.valueOf(jsonObject.get("confidence").getAsFloat()) : null).setDuration(this.hasAndNotNull(jsonObject, "duration") ? Float.valueOf(jsonObject.get("duration").getAsFloat()) : null).setStart(this.hasAndNotNull(jsonObject, "start") ? Float.valueOf(jsonObject.get("start").getAsFloat()) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private Float confidence;
        private Float duration;
        private Float start;

        public Builder setConfidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder setDuration(Float duration) {
            this.duration = duration;
            return this;
        }

        public Builder setStart(Float start) {
            this.start = start;
            return this;
        }

        @Override
        public AudioAnalysisMeasure build() {
            return new AudioAnalysisMeasure(this);
        }
    }
}

