/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify;

import com.google.gson.JsonArray;
import com.neovisionaries.i18n.CountryCode;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import se.michaelthelin.spotify.IHttpManager;
import se.michaelthelin.spotify.SpotifyHttpManager;
import se.michaelthelin.spotify.enums.ModelObjectType;
import se.michaelthelin.spotify.requests.authorization.authorization_code.AuthorizationCodeRefreshRequest;
import se.michaelthelin.spotify.requests.authorization.authorization_code.AuthorizationCodeRequest;
import se.michaelthelin.spotify.requests.authorization.authorization_code.AuthorizationCodeUriRequest;
import se.michaelthelin.spotify.requests.authorization.authorization_code.pkce.AuthorizationCodePKCERefreshRequest;
import se.michaelthelin.spotify.requests.authorization.authorization_code.pkce.AuthorizationCodePKCERequest;
import se.michaelthelin.spotify.requests.authorization.client_credentials.ClientCredentialsRequest;
import se.michaelthelin.spotify.requests.data.albums.GetAlbumRequest;
import se.michaelthelin.spotify.requests.data.albums.GetAlbumsTracksRequest;
import se.michaelthelin.spotify.requests.data.albums.GetSeveralAlbumsRequest;
import se.michaelthelin.spotify.requests.data.artists.GetArtistRequest;
import se.michaelthelin.spotify.requests.data.artists.GetArtistsAlbumsRequest;
import se.michaelthelin.spotify.requests.data.artists.GetArtistsRelatedArtistsRequest;
import se.michaelthelin.spotify.requests.data.artists.GetArtistsTopTracksRequest;
import se.michaelthelin.spotify.requests.data.artists.GetSeveralArtistsRequest;
import se.michaelthelin.spotify.requests.data.browse.GetCategoryRequest;
import se.michaelthelin.spotify.requests.data.browse.GetCategorysPlaylistsRequest;
import se.michaelthelin.spotify.requests.data.browse.GetListOfCategoriesRequest;
import se.michaelthelin.spotify.requests.data.browse.GetListOfFeaturedPlaylistsRequest;
import se.michaelthelin.spotify.requests.data.browse.GetListOfNewReleasesRequest;
import se.michaelthelin.spotify.requests.data.browse.GetRecommendationsRequest;
import se.michaelthelin.spotify.requests.data.browse.miscellaneous.GetAvailableGenreSeedsRequest;
import se.michaelthelin.spotify.requests.data.episodes.GetEpisodeRequest;
import se.michaelthelin.spotify.requests.data.episodes.GetSeveralEpisodesRequest;
import se.michaelthelin.spotify.requests.data.follow.CheckCurrentUserFollowsArtistsOrUsersRequest;
import se.michaelthelin.spotify.requests.data.follow.CheckUsersFollowPlaylistRequest;
import se.michaelthelin.spotify.requests.data.follow.FollowArtistsOrUsersRequest;
import se.michaelthelin.spotify.requests.data.follow.FollowPlaylistRequest;
import se.michaelthelin.spotify.requests.data.follow.GetUsersFollowedArtistsRequest;
import se.michaelthelin.spotify.requests.data.follow.UnfollowArtistsOrUsersRequest;
import se.michaelthelin.spotify.requests.data.follow.UnfollowPlaylistRequest;
import se.michaelthelin.spotify.requests.data.follow.legacy.FollowPlaylistRequest;
import se.michaelthelin.spotify.requests.data.follow.legacy.UnfollowPlaylistRequest;
import se.michaelthelin.spotify.requests.data.library.CheckUsersSavedAlbumsRequest;
import se.michaelthelin.spotify.requests.data.library.CheckUsersSavedShowsRequest;
import se.michaelthelin.spotify.requests.data.library.CheckUsersSavedTracksRequest;
import se.michaelthelin.spotify.requests.data.library.GetCurrentUsersSavedAlbumsRequest;
import se.michaelthelin.spotify.requests.data.library.GetUsersSavedShowsRequest;
import se.michaelthelin.spotify.requests.data.library.GetUsersSavedTracksRequest;
import se.michaelthelin.spotify.requests.data.library.RemoveAlbumsForCurrentUserRequest;
import se.michaelthelin.spotify.requests.data.library.RemoveUsersSavedShowsRequest;
import se.michaelthelin.spotify.requests.data.library.RemoveUsersSavedTracksRequest;
import se.michaelthelin.spotify.requests.data.library.SaveAlbumsForCurrentUserRequest;
import se.michaelthelin.spotify.requests.data.library.SaveShowsForCurrentUserRequest;
import se.michaelthelin.spotify.requests.data.library.SaveTracksForUserRequest;
import se.michaelthelin.spotify.requests.data.personalization.GetUsersTopArtistsAndTracksRequest;
import se.michaelthelin.spotify.requests.data.personalization.interfaces.IArtistTrackModelObject;
import se.michaelthelin.spotify.requests.data.personalization.simplified.GetUsersTopArtistsRequest;
import se.michaelthelin.spotify.requests.data.personalization.simplified.GetUsersTopTracksRequest;
import se.michaelthelin.spotify.requests.data.player.AddItemToUsersPlaybackQueueRequest;
import se.michaelthelin.spotify.requests.data.player.GetCurrentUsersRecentlyPlayedTracksRequest;
import se.michaelthelin.spotify.requests.data.player.GetInformationAboutUsersCurrentPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.GetUsersAvailableDevicesRequest;
import se.michaelthelin.spotify.requests.data.player.GetUsersCurrentlyPlayingTrackRequest;
import se.michaelthelin.spotify.requests.data.player.PauseUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.SeekToPositionInCurrentlyPlayingTrackRequest;
import se.michaelthelin.spotify.requests.data.player.SetRepeatModeOnUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.SetVolumeForUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.SkipUsersPlaybackToNextTrackRequest;
import se.michaelthelin.spotify.requests.data.player.SkipUsersPlaybackToPreviousTrackRequest;
import se.michaelthelin.spotify.requests.data.player.StartResumeUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.ToggleShuffleForUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.player.TransferUsersPlaybackRequest;
import se.michaelthelin.spotify.requests.data.playlists.AddItemsToPlaylistRequest;
import se.michaelthelin.spotify.requests.data.playlists.ChangePlaylistsDetailsRequest;
import se.michaelthelin.spotify.requests.data.playlists.CreatePlaylistRequest;
import se.michaelthelin.spotify.requests.data.playlists.GetListOfCurrentUsersPlaylistsRequest;
import se.michaelthelin.spotify.requests.data.playlists.GetListOfUsersPlaylistsRequest;
import se.michaelthelin.spotify.requests.data.playlists.GetPlaylistCoverImageRequest;
import se.michaelthelin.spotify.requests.data.playlists.GetPlaylistRequest;
import se.michaelthelin.spotify.requests.data.playlists.GetPlaylistsItemsRequest;
import se.michaelthelin.spotify.requests.data.playlists.RemoveItemsFromPlaylistRequest;
import se.michaelthelin.spotify.requests.data.playlists.ReorderPlaylistsItemsRequest;
import se.michaelthelin.spotify.requests.data.playlists.ReplacePlaylistsItemsRequest;
import se.michaelthelin.spotify.requests.data.playlists.UploadCustomPlaylistCoverImageRequest;
import se.michaelthelin.spotify.requests.data.search.SearchItemRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.SearchAlbumsRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.SearchArtistsRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.SearchEpisodesRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.SearchPlaylistsRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.SearchShowsRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.SearchTracksRequest;
import se.michaelthelin.spotify.requests.data.search.simplified.special.SearchAlbumsSpecialRequest;
import se.michaelthelin.spotify.requests.data.shows.GetSeveralShowsRequest;
import se.michaelthelin.spotify.requests.data.shows.GetShowRequest;
import se.michaelthelin.spotify.requests.data.shows.GetShowsEpisodesRequest;
import se.michaelthelin.spotify.requests.data.tracks.GetAudioAnalysisForTrackRequest;
import se.michaelthelin.spotify.requests.data.tracks.GetAudioFeaturesForSeveralTracksRequest;
import se.michaelthelin.spotify.requests.data.tracks.GetAudioFeaturesForTrackRequest;
import se.michaelthelin.spotify.requests.data.tracks.GetSeveralTracksRequest;
import se.michaelthelin.spotify.requests.data.tracks.GetTrackRequest;
import se.michaelthelin.spotify.requests.data.users_profile.GetCurrentUsersProfileRequest;
import se.michaelthelin.spotify.requests.data.users_profile.GetUsersProfileRequest;

public class SpotifyApi {
    public static final String DEFAULT_AUTHENTICATION_HOST = "accounts.spotify.com";
    public static final int DEFAULT_AUTHENTICATION_PORT = 443;
    public static final String DEFAULT_AUTHENTICATION_SCHEME = "https";
    public static final String DEFAULT_HOST = "api.spotify.com";
    public static final IHttpManager DEFAULT_HTTP_MANAGER = new SpotifyHttpManager.Builder().build();
    public static final int DEFAULT_PORT = 443;
    public static final String DEFAULT_SCHEME = "https";
    public static final Logger LOGGER = Logger.getLogger(SpotifyApi.class.getName());
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT = ThreadLocal.withInitial(() -> SpotifyApi.makeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", "GMT"));
    private final IHttpManager httpManager;
    private final String scheme;
    private final String host;
    private final Integer port;
    private final String proxyUrl;
    private final Integer proxyPort;
    private final Integer proxyUsername;
    private final Integer proxyPassword;
    private final String clientId;
    private final String clientSecret;
    private final URI redirectUri;
    private String accessToken;
    private String refreshToken;

    private SpotifyApi(Builder builder) {
        assert (builder.httpManager != null);
        this.httpManager = builder.httpManager;
        this.scheme = builder.scheme;
        this.host = builder.host;
        this.port = builder.port;
        this.proxyUrl = builder.proxyUrl;
        this.proxyPort = builder.proxyPort;
        this.proxyUsername = builder.proxyUsername;
        this.proxyPassword = builder.proxyPassword;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.redirectUri = builder.redirectUri;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String concat(String[] parts, char character) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String part : parts) {
            stringBuilder.append(part).append(character);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static Date parseDefaultDate(String date) throws ParseException {
        return SIMPLE_DATE_FORMAT.get().parse(date);
    }

    public static String formatDefaultDate(Date date) {
        return SIMPLE_DATE_FORMAT.get().format(date);
    }

    public static SimpleDateFormat makeSimpleDateFormat(String pattern, String id) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(id));
        return simpleDateFormat;
    }

    public IHttpManager getHttpManager() {
        return this.httpManager;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public Integer getProxyUsername() {
        return this.proxyUsername;
    }

    public Integer getProxyPassword() {
        return this.proxyPassword;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public URI getRedirectURI() {
        return this.redirectUri;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public AuthorizationCodeRefreshRequest.Builder authorizationCodeRefresh(String client_id, String client_secret, String refresh_token) {
        return ((AuthorizationCodeRefreshRequest.Builder)new AuthorizationCodeRefreshRequest.Builder(client_id, client_secret).setDefaults(this.httpManager, this.scheme, this.host, this.port)).grant_type("refresh_token").refresh_token(refresh_token);
    }

    public AuthorizationCodeRefreshRequest.Builder authorizationCodeRefresh() {
        return ((AuthorizationCodeRefreshRequest.Builder)new AuthorizationCodeRefreshRequest.Builder(this.clientId, this.clientSecret).setDefaults(this.httpManager, this.scheme, this.host, this.port)).grant_type("refresh_token").refresh_token(this.refreshToken);
    }

    public AuthorizationCodePKCERefreshRequest.Builder authorizationCodePKCERefresh(String client_id, String refresh_token) {
        return ((AuthorizationCodePKCERefreshRequest.Builder)new AuthorizationCodePKCERefreshRequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(client_id).grant_type("refresh_token").refresh_token(refresh_token);
    }

    public AuthorizationCodePKCERefreshRequest.Builder authorizationCodePKCERefresh() {
        return ((AuthorizationCodePKCERefreshRequest.Builder)new AuthorizationCodePKCERefreshRequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(this.clientId).grant_type("refresh_token").refresh_token(this.refreshToken);
    }

    public AuthorizationCodeRequest.Builder authorizationCode(String client_id, String client_secret, String code, URI redirect_uri) {
        return ((AuthorizationCodeRequest.Builder)new AuthorizationCodeRequest.Builder(client_id, client_secret).setDefaults(this.httpManager, this.scheme, this.host, this.port)).grant_type("authorization_code").code(code).redirect_uri(redirect_uri);
    }

    public AuthorizationCodeRequest.Builder authorizationCode(String code) {
        return ((AuthorizationCodeRequest.Builder)new AuthorizationCodeRequest.Builder(this.clientId, this.clientSecret).setDefaults(this.httpManager, this.scheme, this.host, this.port)).grant_type("authorization_code").code(code).redirect_uri(this.redirectUri);
    }

    public AuthorizationCodePKCERequest.Builder authorizationCodePKCE(String client_id, String code, String code_verifier, URI redirect_uri) {
        return ((AuthorizationCodePKCERequest.Builder)new AuthorizationCodePKCERequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(client_id).code_verifier(code_verifier).grant_type("authorization_code").code(code).redirect_uri(redirect_uri);
    }

    public AuthorizationCodePKCERequest.Builder authorizationCodePKCE(String code, String code_verifier) {
        return ((AuthorizationCodePKCERequest.Builder)new AuthorizationCodePKCERequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(this.clientId).code_verifier(code_verifier).grant_type("authorization_code").code(code).redirect_uri(this.redirectUri);
    }

    public AuthorizationCodeUriRequest.Builder authorizationCodeUri(String client_id, URI redirect_uri) {
        return ((AuthorizationCodeUriRequest.Builder)new AuthorizationCodeUriRequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(client_id).response_type("code").redirect_uri(redirect_uri);
    }

    public AuthorizationCodeUriRequest.Builder authorizationCodeUri() {
        return ((AuthorizationCodeUriRequest.Builder)new AuthorizationCodeUriRequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(this.clientId).response_type("code").redirect_uri(this.redirectUri);
    }

    public AuthorizationCodeUriRequest.Builder authorizationCodePKCEUri(String client_id, String code_challenge, URI redirect_uri) {
        return ((AuthorizationCodeUriRequest.Builder)new AuthorizationCodeUriRequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(client_id).response_type("code").code_challenge_method("S256").code_challenge(code_challenge).redirect_uri(redirect_uri);
    }

    public AuthorizationCodeUriRequest.Builder authorizationCodePKCEUri(String code_challenge) {
        return ((AuthorizationCodeUriRequest.Builder)new AuthorizationCodeUriRequest.Builder().setDefaults(this.httpManager, this.scheme, this.host, this.port)).client_id(this.clientId).response_type("code").code_challenge_method("S256").code_challenge(code_challenge).redirect_uri(this.redirectUri);
    }

    public ClientCredentialsRequest.Builder clientCredentials() {
        return ((ClientCredentialsRequest.Builder)new ClientCredentialsRequest.Builder(this.clientId, this.clientSecret).setDefaults(this.httpManager, this.scheme, this.host, this.port)).grant_type("client_credentials");
    }

    public GetAlbumRequest.Builder getAlbum(String id) {
        return ((GetAlbumRequest.Builder)new GetAlbumRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetAlbumsTracksRequest.Builder getAlbumsTracks(String id) {
        return ((GetAlbumsTracksRequest.Builder)new GetAlbumsTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetSeveralAlbumsRequest.Builder getSeveralAlbums(String ... ids) {
        return ((GetSeveralAlbumsRequest.Builder)new GetSeveralAlbumsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public GetArtistRequest.Builder getArtist(String id) {
        return ((GetArtistRequest.Builder)new GetArtistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetArtistsAlbumsRequest.Builder getArtistsAlbums(String id) {
        return ((GetArtistsAlbumsRequest.Builder)new GetArtistsAlbumsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetArtistsTopTracksRequest.Builder getArtistsTopTracks(String id, CountryCode country) {
        return ((GetArtistsTopTracksRequest.Builder)new GetArtistsTopTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id).country(country);
    }

    public GetArtistsRelatedArtistsRequest.Builder getArtistsRelatedArtists(String id) {
        return ((GetArtistsRelatedArtistsRequest.Builder)new GetArtistsRelatedArtistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetSeveralArtistsRequest.Builder getSeveralArtists(String ... ids) {
        return ((GetSeveralArtistsRequest.Builder)new GetSeveralArtistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public GetCategoryRequest.Builder getCategory(String category_id) {
        return ((GetCategoryRequest.Builder)new GetCategoryRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).category_id(category_id);
    }

    public GetCategorysPlaylistsRequest.Builder getCategorysPlaylists(String category_id) {
        return ((GetCategorysPlaylistsRequest.Builder)new GetCategorysPlaylistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).category_id(category_id);
    }

    public GetListOfCategoriesRequest.Builder getListOfCategories() {
        return (GetListOfCategoriesRequest.Builder)new GetListOfCategoriesRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetListOfFeaturedPlaylistsRequest.Builder getListOfFeaturedPlaylists() {
        return (GetListOfFeaturedPlaylistsRequest.Builder)new GetListOfFeaturedPlaylistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetListOfNewReleasesRequest.Builder getListOfNewReleases() {
        return (GetListOfNewReleasesRequest.Builder)new GetListOfNewReleasesRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetRecommendationsRequest.Builder getRecommendations() {
        return (GetRecommendationsRequest.Builder)new GetRecommendationsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetAvailableGenreSeedsRequest.Builder getAvailableGenreSeeds() {
        return (GetAvailableGenreSeedsRequest.Builder)new GetAvailableGenreSeedsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetEpisodeRequest.Builder getEpisode(String id) {
        return ((GetEpisodeRequest.Builder)new GetEpisodeRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetSeveralEpisodesRequest.Builder getSeveralEpisodes(String ... ids) {
        return ((GetSeveralEpisodesRequest.Builder)new GetSeveralEpisodesRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public CheckCurrentUserFollowsArtistsOrUsersRequest.Builder checkCurrentUserFollowsArtistsOrUsers(ModelObjectType type, String[] ids) {
        return ((CheckCurrentUserFollowsArtistsOrUsersRequest.Builder)new CheckCurrentUserFollowsArtistsOrUsersRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).type(type).ids(SpotifyApi.concat(ids, ','));
    }

    public CheckUsersFollowPlaylistRequest.Builder checkUsersFollowPlaylist(String owner_id, String playlist_id, String[] ids) {
        return ((CheckUsersFollowPlaylistRequest.Builder)new CheckUsersFollowPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).owner_id(owner_id).playlist_id(playlist_id).ids(SpotifyApi.concat(ids, ','));
    }

    public FollowArtistsOrUsersRequest.Builder followArtistsOrUsers(ModelObjectType type, String[] ids) {
        return ((FollowArtistsOrUsersRequest.Builder)new FollowArtistsOrUsersRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).type(type).ids(SpotifyApi.concat(ids, ','));
    }

    public FollowArtistsOrUsersRequest.Builder followArtistsOrUsers(ModelObjectType type, JsonArray ids) {
        return ((FollowArtistsOrUsersRequest.Builder)new FollowArtistsOrUsersRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).type(type).ids(ids);
    }

    public FollowPlaylistRequest.Builder followPlaylist(String owner_id, String playlist_id, boolean public_) {
        return ((FollowPlaylistRequest.Builder)new FollowPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).owner_id(owner_id).playlist_id(playlist_id).public_(public_);
    }

    public FollowPlaylistRequest.Builder followPlaylist(String playlist_id, boolean public_) {
        return ((FollowPlaylistRequest.Builder)new FollowPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id).public_(public_);
    }

    public GetUsersFollowedArtistsRequest.Builder getUsersFollowedArtists(ModelObjectType type) {
        return ((GetUsersFollowedArtistsRequest.Builder)new GetUsersFollowedArtistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).type(type);
    }

    public UnfollowArtistsOrUsersRequest.Builder unfollowArtistsOrUsers(ModelObjectType type, String[] ids) {
        return ((UnfollowArtistsOrUsersRequest.Builder)new UnfollowArtistsOrUsersRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).type(type).ids(SpotifyApi.concat(ids, ','));
    }

    public UnfollowArtistsOrUsersRequest.Builder unfollowArtistsOrUsers(ModelObjectType type, JsonArray ids) {
        return ((UnfollowArtistsOrUsersRequest.Builder)new UnfollowArtistsOrUsersRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).type(type).ids(ids);
    }

    public UnfollowPlaylistRequest.Builder unfollowPlaylist(String owner_id, String playlist_id) {
        return ((UnfollowPlaylistRequest.Builder)new UnfollowPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).owner_id(owner_id).playlist_id(playlist_id);
    }

    public UnfollowPlaylistRequest.Builder unfollowPlaylist(String playlist_id) {
        return ((UnfollowPlaylistRequest.Builder)new UnfollowPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id);
    }

    public CheckUsersSavedAlbumsRequest.Builder checkUsersSavedAlbums(String ... ids) {
        return ((CheckUsersSavedAlbumsRequest.Builder)new CheckUsersSavedAlbumsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public CheckUsersSavedShowsRequest.Builder checkUsersSavedShows(String ... ids) {
        return ((CheckUsersSavedShowsRequest.Builder)new CheckUsersSavedShowsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public CheckUsersSavedTracksRequest.Builder checkUsersSavedTracks(String ... ids) {
        return ((CheckUsersSavedTracksRequest.Builder)new CheckUsersSavedTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public GetCurrentUsersSavedAlbumsRequest.Builder getCurrentUsersSavedAlbums() {
        return (GetCurrentUsersSavedAlbumsRequest.Builder)new GetCurrentUsersSavedAlbumsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetUsersSavedShowsRequest.Builder getUsersSavedShows() {
        return (GetUsersSavedShowsRequest.Builder)new GetUsersSavedShowsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetUsersSavedTracksRequest.Builder getUsersSavedTracks() {
        return (GetUsersSavedTracksRequest.Builder)new GetUsersSavedTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public RemoveAlbumsForCurrentUserRequest.Builder removeAlbumsForCurrentUser(String ... ids) {
        return ((RemoveAlbumsForCurrentUserRequest.Builder)new RemoveAlbumsForCurrentUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public RemoveAlbumsForCurrentUserRequest.Builder removeAlbumsForCurrentUser(JsonArray ids) {
        return ((RemoveAlbumsForCurrentUserRequest.Builder)new RemoveAlbumsForCurrentUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(ids);
    }

    public RemoveUsersSavedShowsRequest.Builder removeUsersSavedShows(String ... ids) {
        return ((RemoveUsersSavedShowsRequest.Builder)new RemoveUsersSavedShowsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public RemoveUsersSavedShowsRequest.Builder removeUsersSavedShows(JsonArray ids) {
        return ((RemoveUsersSavedShowsRequest.Builder)new RemoveUsersSavedShowsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(ids);
    }

    public RemoveUsersSavedTracksRequest.Builder removeUsersSavedTracks(String ... ids) {
        return ((RemoveUsersSavedTracksRequest.Builder)new RemoveUsersSavedTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public RemoveUsersSavedTracksRequest.Builder removeUsersSavedTracks(JsonArray ids) {
        return ((RemoveUsersSavedTracksRequest.Builder)new RemoveUsersSavedTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(ids);
    }

    public SaveAlbumsForCurrentUserRequest.Builder saveAlbumsForCurrentUser(String ... ids) {
        return ((SaveAlbumsForCurrentUserRequest.Builder)new SaveAlbumsForCurrentUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public SaveAlbumsForCurrentUserRequest.Builder saveAlbumsForCurrentUser(JsonArray ids) {
        return ((SaveAlbumsForCurrentUserRequest.Builder)new SaveAlbumsForCurrentUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(ids);
    }

    public SaveShowsForCurrentUserRequest.Builder saveShowsForCurrentUser(String ... ids) {
        return ((SaveShowsForCurrentUserRequest.Builder)new SaveShowsForCurrentUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public SaveShowsForCurrentUserRequest.Builder saveShowsForCurrentUser(JsonArray ids) {
        return ((SaveShowsForCurrentUserRequest.Builder)new SaveShowsForCurrentUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(ids);
    }

    public SaveTracksForUserRequest.Builder saveTracksForUser(String ... ids) {
        return ((SaveTracksForUserRequest.Builder)new SaveTracksForUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public SaveTracksForUserRequest.Builder saveTracksForUser(JsonArray ids) {
        return ((SaveTracksForUserRequest.Builder)new SaveTracksForUserRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(ids);
    }

    public <T extends IArtistTrackModelObject> GetUsersTopArtistsAndTracksRequest.Builder<T> getUsersTopArtistsAndTracks(ModelObjectType type) {
        return ((GetUsersTopArtistsAndTracksRequest.Builder)new GetUsersTopArtistsAndTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).type(type);
    }

    public GetUsersTopArtistsRequest.Builder getUsersTopArtists() {
        return (GetUsersTopArtistsRequest.Builder)new GetUsersTopArtistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetUsersTopTracksRequest.Builder getUsersTopTracks() {
        return (GetUsersTopTracksRequest.Builder)new GetUsersTopTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetInformationAboutUsersCurrentPlaybackRequest.Builder getInformationAboutUsersCurrentPlayback() {
        return (GetInformationAboutUsersCurrentPlaybackRequest.Builder)new GetInformationAboutUsersCurrentPlaybackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetCurrentUsersRecentlyPlayedTracksRequest.Builder getCurrentUsersRecentlyPlayedTracks() {
        return (GetCurrentUsersRecentlyPlayedTracksRequest.Builder)new GetCurrentUsersRecentlyPlayedTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetUsersAvailableDevicesRequest.Builder getUsersAvailableDevices() {
        return (GetUsersAvailableDevicesRequest.Builder)new GetUsersAvailableDevicesRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetUsersCurrentlyPlayingTrackRequest.Builder getUsersCurrentlyPlayingTrack() {
        return (GetUsersCurrentlyPlayingTrackRequest.Builder)new GetUsersCurrentlyPlayingTrackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public PauseUsersPlaybackRequest.Builder pauseUsersPlayback() {
        return (PauseUsersPlaybackRequest.Builder)new PauseUsersPlaybackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public SeekToPositionInCurrentlyPlayingTrackRequest.Builder seekToPositionInCurrentlyPlayingTrack(int position_ms) {
        return ((SeekToPositionInCurrentlyPlayingTrackRequest.Builder)new SeekToPositionInCurrentlyPlayingTrackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).position_ms(position_ms);
    }

    public SetRepeatModeOnUsersPlaybackRequest.Builder setRepeatModeOnUsersPlayback(String state) {
        return ((SetRepeatModeOnUsersPlaybackRequest.Builder)new SetRepeatModeOnUsersPlaybackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).state(state);
    }

    public SetVolumeForUsersPlaybackRequest.Builder setVolumeForUsersPlayback(int volume_percent) {
        return ((SetVolumeForUsersPlaybackRequest.Builder)new SetVolumeForUsersPlaybackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).volume_percent(volume_percent);
    }

    public SkipUsersPlaybackToNextTrackRequest.Builder skipUsersPlaybackToNextTrack() {
        return (SkipUsersPlaybackToNextTrackRequest.Builder)new SkipUsersPlaybackToNextTrackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public SkipUsersPlaybackToPreviousTrackRequest.Builder skipUsersPlaybackToPreviousTrack() {
        return (SkipUsersPlaybackToPreviousTrackRequest.Builder)new SkipUsersPlaybackToPreviousTrackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public StartResumeUsersPlaybackRequest.Builder startResumeUsersPlayback() {
        return (StartResumeUsersPlaybackRequest.Builder)new StartResumeUsersPlaybackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public ToggleShuffleForUsersPlaybackRequest.Builder toggleShuffleForUsersPlayback(boolean state) {
        return ((ToggleShuffleForUsersPlaybackRequest.Builder)new ToggleShuffleForUsersPlaybackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).state(state);
    }

    public TransferUsersPlaybackRequest.Builder transferUsersPlayback(JsonArray device_ids) {
        return ((TransferUsersPlaybackRequest.Builder)new TransferUsersPlaybackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).device_ids(device_ids);
    }

    public AddItemToUsersPlaybackQueueRequest.Builder addItemToUsersPlaybackQueue(String uri) {
        return ((AddItemToUsersPlaybackQueueRequest.Builder)new AddItemToUsersPlaybackQueueRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).uri(uri);
    }

    public AddItemsToPlaylistRequest.Builder addItemsToPlaylist(String playlist_id, String[] uris) {
        return ((AddItemsToPlaylistRequest.Builder)new AddItemsToPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id).uris(SpotifyApi.concat(uris, ','));
    }

    public AddItemsToPlaylistRequest.Builder addItemsToPlaylist(String playlist_id, JsonArray uris) {
        return ((AddItemsToPlaylistRequest.Builder)new AddItemsToPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id).uris(uris);
    }

    public ChangePlaylistsDetailsRequest.Builder changePlaylistsDetails(String playlist_id) {
        return ((ChangePlaylistsDetailsRequest.Builder)new ChangePlaylistsDetailsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id);
    }

    public CreatePlaylistRequest.Builder createPlaylist(String user_id, String name) {
        return ((CreatePlaylistRequest.Builder)new CreatePlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).user_id(user_id).name(name);
    }

    public GetListOfCurrentUsersPlaylistsRequest.Builder getListOfCurrentUsersPlaylists() {
        return (GetListOfCurrentUsersPlaylistsRequest.Builder)new GetListOfCurrentUsersPlaylistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetListOfUsersPlaylistsRequest.Builder getListOfUsersPlaylists(String user_id) {
        return ((GetListOfUsersPlaylistsRequest.Builder)new GetListOfUsersPlaylistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).user_id(user_id);
    }

    public GetPlaylistRequest.Builder getPlaylist(String playlist_id) {
        return ((GetPlaylistRequest.Builder)new GetPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id);
    }

    public GetPlaylistCoverImageRequest.Builder getPlaylistCoverImage(String playlist_id) {
        return ((GetPlaylistCoverImageRequest.Builder)new GetPlaylistCoverImageRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id);
    }

    public GetPlaylistsItemsRequest.Builder getPlaylistsItems(String playlist_id) {
        return ((GetPlaylistsItemsRequest.Builder)new GetPlaylistsItemsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id);
    }

    public RemoveItemsFromPlaylistRequest.Builder removeItemsFromPlaylist(String playlist_id, JsonArray tracks) {
        return ((RemoveItemsFromPlaylistRequest.Builder)new RemoveItemsFromPlaylistRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id).tracks(tracks);
    }

    public ReorderPlaylistsItemsRequest.Builder reorderPlaylistsItems(String playlist_id, int range_start, int insert_before) {
        return ((ReorderPlaylistsItemsRequest.Builder)new ReorderPlaylistsItemsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id).range_start(range_start).insert_before(insert_before);
    }

    public ReplacePlaylistsItemsRequest.Builder replacePlaylistsItems(String playlist_id, String[] uris) {
        return ((ReplacePlaylistsItemsRequest.Builder)new ReplacePlaylistsItemsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id).uris(SpotifyApi.concat(uris, ','));
    }

    public ReplacePlaylistsItemsRequest.Builder replacePlaylistsItems(String playlist_id, JsonArray uris) {
        return ((ReplacePlaylistsItemsRequest.Builder)new ReplacePlaylistsItemsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id).uris(uris);
    }

    public UploadCustomPlaylistCoverImageRequest.Builder uploadCustomPlaylistCoverImage(String playlist_id) {
        return ((UploadCustomPlaylistCoverImageRequest.Builder)new UploadCustomPlaylistCoverImageRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).playlist_id(playlist_id);
    }

    public SearchItemRequest.Builder searchItem(String q, String type) {
        return ((SearchItemRequest.Builder)new SearchItemRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q).type(type);
    }

    public SearchAlbumsRequest.Builder searchAlbums(String q) {
        return ((SearchAlbumsRequest.Builder)new SearchAlbumsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q);
    }

    public SearchAlbumsSpecialRequest.Builder searchAlbumsSpecial(String q) {
        return ((SearchAlbumsSpecialRequest.Builder)new SearchAlbumsSpecialRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q);
    }

    public SearchArtistsRequest.Builder searchArtists(String q) {
        return ((SearchArtistsRequest.Builder)new SearchArtistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q);
    }

    public SearchEpisodesRequest.Builder searchEpisodes(String q) {
        return ((SearchEpisodesRequest.Builder)new SearchEpisodesRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q);
    }

    public SearchPlaylistsRequest.Builder searchPlaylists(String q) {
        return ((SearchPlaylistsRequest.Builder)new SearchPlaylistsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q);
    }

    public SearchShowsRequest.Builder searchShows(String q) {
        return ((SearchShowsRequest.Builder)new SearchShowsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q);
    }

    public SearchTracksRequest.Builder searchTracks(String q) {
        return ((SearchTracksRequest.Builder)new SearchTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).q(q);
    }

    public GetShowRequest.Builder getShow(String id) {
        return ((GetShowRequest.Builder)new GetShowRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetSeveralShowsRequest.Builder getSeveralShows(String ... ids) {
        return ((GetSeveralShowsRequest.Builder)new GetSeveralShowsRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public GetShowsEpisodesRequest.Builder getShowEpisodes(String id) {
        return ((GetShowsEpisodesRequest.Builder)new GetShowsEpisodesRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetAudioAnalysisForTrackRequest.Builder getAudioAnalysisForTrack(String id) {
        return ((GetAudioAnalysisForTrackRequest.Builder)new GetAudioAnalysisForTrackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetAudioFeaturesForTrackRequest.Builder getAudioFeaturesForTrack(String id) {
        return ((GetAudioFeaturesForTrackRequest.Builder)new GetAudioFeaturesForTrackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetAudioFeaturesForSeveralTracksRequest.Builder getAudioFeaturesForSeveralTracks(String ... ids) {
        return ((GetAudioFeaturesForSeveralTracksRequest.Builder)new GetAudioFeaturesForSeveralTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public GetSeveralTracksRequest.Builder getSeveralTracks(String ... ids) {
        return ((GetSeveralTracksRequest.Builder)new GetSeveralTracksRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).ids(SpotifyApi.concat(ids, ','));
    }

    public GetTrackRequest.Builder getTrack(String id) {
        return ((GetTrackRequest.Builder)new GetTrackRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).id(id);
    }

    public GetCurrentUsersProfileRequest.Builder getCurrentUsersProfile() {
        return (GetCurrentUsersProfileRequest.Builder)new GetCurrentUsersProfileRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port);
    }

    public GetUsersProfileRequest.Builder getUsersProfile(String user_id) {
        return ((GetUsersProfileRequest.Builder)new GetUsersProfileRequest.Builder(this.accessToken).setDefaults(this.httpManager, this.scheme, this.host, this.port)).user_id(user_id);
    }

    public static class Builder {
        private IHttpManager httpManager = DEFAULT_HTTP_MANAGER;
        private String scheme = "https";
        private String host = "api.spotify.com";
        private Integer port = 443;
        private String proxyUrl;
        private Integer proxyPort;
        private Integer proxyUsername;
        private Integer proxyPassword;
        private String clientId;
        private String clientSecret;
        private URI redirectUri;
        private String accessToken;
        private String refreshToken;

        public Builder setHttpManager(IHttpManager httpManager) {
            this.httpManager = httpManager;
            return this;
        }

        public Builder setScheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder setProxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this;
        }

        public Builder setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder setProxyUsername(Integer proxyUsername) {
            this.proxyUsername = proxyUsername;
            return this;
        }

        public Builder setProxyPassword(Integer proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setRedirectUri(URI redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public SpotifyApi build() {
            return new SpotifyApi(this);
        }
    }
}

