/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.util.Objects;
import se.michaelthelin.spotify.enums.ModelObjectType;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.specification.ExternalUrl;

@JsonDeserialize(builder=Builder.class)
public class ArtistSimplified
extends AbstractModelObject {
    private final ExternalUrl externalUrls;
    private final String href;
    private final String id;
    private final String name;
    private final ModelObjectType type;
    private final String uri;

    private ArtistSimplified(Builder builder) {
        super(builder);
        this.externalUrls = builder.externalUrls;
        this.href = builder.href;
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    public ExternalUrl getExternalUrls() {
        return this.externalUrls;
    }

    public String getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ModelObjectType getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public String toString() {
        return "ArtistSimplified(name=" + this.name + ", externalUrls=" + this.externalUrls + ", href=" + this.href + ", id=" + this.id + ", type=" + this.type + ", uri=" + this.uri + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtistSimplified artist = (ArtistSimplified)o;
        return Objects.equals(this.id, artist.id) && Objects.equals(this.name, artist.name) && Objects.equals(this.uri, artist.uri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.uri);
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<ArtistSimplified> {
        @Override
        public ArtistSimplified createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setExternalUrls(this.hasAndNotNull(jsonObject, "external_urls") ? new ExternalUrl.JsonUtil().createModelObject(jsonObject.getAsJsonObject("external_urls")) : null).setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setId(this.hasAndNotNull(jsonObject, "id") ? jsonObject.get("id").getAsString() : null).setName(this.hasAndNotNull(jsonObject, "name") ? jsonObject.get("name").getAsString() : null).setType(this.hasAndNotNull(jsonObject, "type") ? ModelObjectType.keyOf(jsonObject.get("type").getAsString().toLowerCase()) : null).setUri(this.hasAndNotNull(jsonObject, "uri") ? jsonObject.get("uri").getAsString() : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private ExternalUrl externalUrls;
        private String href;
        private String id;
        private String name;
        private ModelObjectType type;
        private String uri;

        public Builder setExternalUrls(ExternalUrl externalUrls) {
            this.externalUrls = externalUrls;
            return this;
        }

        public Builder setHref(String href) {
            this.href = href;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(ModelObjectType type) {
            this.type = type;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public ArtistSimplified build() {
            return new ArtistSimplified(this);
        }
    }
}

