/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.search;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.special.SearchResult;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class SearchItemRequest
extends AbstractDataRequest<SearchResult> {
    private SearchItemRequest(Builder builder) {
        super(builder);
    }

    @Override
    public SearchResult execute() throws IOException, SpotifyWebApiException, ParseException {
        return (SearchResult)new SearchResult.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<SearchResult, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder q(String q) {
            assert (q != null);
            assert (!q.equals(""));
            return (Builder)this.setQueryParameter("q", q);
        }

        public Builder type(String type) {
            assert (type != null);
            assert (type.matches("((^|,)(album|artist|episode|playlist|show|track))+$"));
            return (Builder)this.setQueryParameter("type", type);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        public Builder offset(Integer offset) {
            assert (offset != null);
            assert (0 <= offset && offset <= 100000);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder includeExternal(String includeExternal) {
            assert (includeExternal != null);
            assert (includeExternal.matches("audio"));
            return (Builder)this.setQueryParameter("include_external", includeExternal);
        }

        public SearchItemRequest build() {
            this.setPath("/v1/search");
            return new SearchItemRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

