/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.credentials;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.util.Objects;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;

@JsonDeserialize(builder=Builder.class)
public class ClientCredentials
extends AbstractModelObject {
    private final String accessToken;
    private final String tokenType;
    private final Integer expiresIn;

    private ClientCredentials(Builder builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.expiresIn = builder.expiresIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    @Override
    public String toString() {
        return "ClientCredentials(accessToken=" + this.accessToken + ", tokenType=" + this.tokenType + ", expiresIn=" + this.expiresIn + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCredentials that = (ClientCredentials)o;
        return Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.tokenType, that.tokenType) && Objects.equals(this.expiresIn, that.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.tokenType, this.expiresIn);
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<ClientCredentials> {
        @Override
        public ClientCredentials createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setAccessToken(this.hasAndNotNull(jsonObject, "access_token") ? jsonObject.get("access_token").getAsString() : null).setTokenType(this.hasAndNotNull(jsonObject, "token_type") ? jsonObject.get("token_type").getAsString() : null).setExpiresIn(this.hasAndNotNull(jsonObject, "expires_in") ? Integer.valueOf(jsonObject.get("expires_in").getAsInt()) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private String accessToken;
        private String tokenType;
        private Integer expiresIn;

        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setTokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @Override
        public ClientCredentials build() {
            return new ClientCredentials(this);
        }
    }
}

