/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import se.michaelthelin.spotify.enums.ModelObjectType;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.specification.ExternalUrl;
import se.michaelthelin.spotify.model_objects.specification.Followers;
import se.michaelthelin.spotify.model_objects.specification.Image;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.PlaylistTrack;
import se.michaelthelin.spotify.model_objects.specification.User;

@JsonDeserialize(builder=Builder.class)
public class Playlist
extends AbstractModelObject {
    private final Boolean collaborative;
    private final String description;
    private final ExternalUrl externalUrls;
    private final Followers followers;
    private final String href;
    private final String id;
    private final Image[] images;
    private final String name;
    private final User owner;
    private final Boolean publicAccess;
    private final String snapshotId;
    private final Paging<PlaylistTrack> tracks;
    private final ModelObjectType type;
    private final String uri;

    private Playlist(Builder builder) {
        super(builder);
        this.collaborative = builder.collaborative;
        this.description = builder.description;
        this.externalUrls = builder.externalUrls;
        this.followers = builder.followers;
        this.href = builder.href;
        this.id = builder.id;
        this.images = builder.images;
        this.name = builder.name;
        this.owner = builder.owner;
        this.publicAccess = builder.publicAccess;
        this.snapshotId = builder.snapshotId;
        this.tracks = builder.tracks;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    public Boolean getIsCollaborative() {
        return this.collaborative;
    }

    public String getDescription() {
        return this.description;
    }

    public ExternalUrl getExternalUrls() {
        return this.externalUrls;
    }

    public Followers getFollowers() {
        return this.followers;
    }

    public String getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public Image[] getImages() {
        return this.images;
    }

    public String getName() {
        return this.name;
    }

    public User getOwner() {
        return this.owner;
    }

    public Boolean getIsPublicAccess() {
        return this.publicAccess;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Paging<PlaylistTrack> getTracks() {
        return this.tracks;
    }

    public ModelObjectType getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public String toString() {
        return "Playlist(name=" + this.name + ", description=" + this.description + ", tracks=" + this.tracks + ", collaborative=" + this.collaborative + ", externalUrls=" + this.externalUrls + ", followers=" + this.followers + ", href=" + this.href + ", id=" + this.id + ", images=" + Arrays.toString(this.images) + ", owner=" + this.owner + ", publicAccess=" + this.publicAccess + ", snapshotId=" + this.snapshotId + ", type=" + this.type + ", uri=" + this.uri + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Playlist playlist = (Playlist)o;
        return Objects.equals(this.id, playlist.id) && Objects.equals(this.name, playlist.name) && Objects.equals(this.uri, playlist.uri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.uri);
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<Playlist> {
        @Override
        public Playlist createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setCollaborative(this.hasAndNotNull(jsonObject, "collaborative") ? Boolean.valueOf(jsonObject.get("collaborative").getAsBoolean()) : null).setDescription(this.hasAndNotNull(jsonObject, "description") ? jsonObject.get("description").getAsString() : null).setExternalUrls(this.hasAndNotNull(jsonObject, "external_urls") ? new ExternalUrl.JsonUtil().createModelObject(jsonObject.getAsJsonObject("external_urls")) : null).setFollowers(this.hasAndNotNull(jsonObject, "followers") ? new Followers.JsonUtil().createModelObject(jsonObject.getAsJsonObject("followers")) : null).setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setId(this.hasAndNotNull(jsonObject, "id") ? jsonObject.get("id").getAsString() : null).setImages(this.hasAndNotNull(jsonObject, "images") ? (Image[])new Image.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("images")) : null).setName(this.hasAndNotNull(jsonObject, "name") ? jsonObject.get("name").getAsString() : null).setOwner(this.hasAndNotNull(jsonObject, "owner") ? new User.JsonUtil().createModelObject(jsonObject.getAsJsonObject("owner")) : null).setPublicAccess(this.hasAndNotNull(jsonObject, "public") ? Boolean.valueOf(jsonObject.get("public").getAsBoolean()) : null).setSnapshotId(this.hasAndNotNull(jsonObject, "snapshot_id") ? jsonObject.get("snapshot_id").getAsString() : null).setTracks(this.hasAndNotNull(jsonObject, "tracks") ? new PlaylistTrack.JsonUtil().createModelObjectPaging(jsonObject.getAsJsonObject("tracks")) : null).setType(this.hasAndNotNull(jsonObject, "type") ? ModelObjectType.keyOf(jsonObject.get("type").getAsString().toLowerCase()) : null).setUri(this.hasAndNotNull(jsonObject, "uri") ? jsonObject.get("uri").getAsString() : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private Boolean collaborative;
        private String description;
        private ExternalUrl externalUrls;
        private Followers followers;
        private String href;
        private String id;
        private Image[] images;
        private String name;
        private User owner;
        private Boolean publicAccess;
        private String snapshotId;
        private Paging<PlaylistTrack> tracks;
        private ModelObjectType type;
        private String uri;

        public Builder setCollaborative(Boolean collaborative) {
            this.collaborative = collaborative;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setExternalUrls(ExternalUrl externalUrls) {
            this.externalUrls = externalUrls;
            return this;
        }

        public Builder setFollowers(Followers followers) {
            this.followers = followers;
            return this;
        }

        public Builder setHref(String href) {
            this.href = href;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setImages(Image ... images) {
            this.images = images;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setOwner(User owner) {
            this.owner = owner;
            return this;
        }

        public Builder setPublicAccess(Boolean publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public Builder setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public Builder setTracks(Paging<PlaylistTrack> tracks) {
            this.tracks = tracks;
            return this;
        }

        public Builder setType(ModelObjectType type) {
            this.type = type;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public Playlist build() {
            return new Playlist(this);
        }
    }
}

