/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.player;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.miscellaneous.CurrentlyPlaying;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetUsersCurrentlyPlayingTrackRequest
extends AbstractDataRequest<CurrentlyPlaying> {
    private GetUsersCurrentlyPlayingTrackRequest(Builder builder) {
        super(builder);
    }

    @Override
    public CurrentlyPlaying execute() throws IOException, SpotifyWebApiException, ParseException {
        return (CurrentlyPlaying)new CurrentlyPlaying.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<CurrentlyPlaying, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public Builder additionalTypes(String additionalTypes) {
            assert (additionalTypes != null);
            assert (additionalTypes.matches("((^|,)(episode|track))+$"));
            return (Builder)this.setQueryParameter("additional_types", additionalTypes);
        }

        public GetUsersCurrentlyPlayingTrackRequest build() {
            this.setPath("/v1/me/player/currently-playing");
            return new GetUsersCurrentlyPlayingTrackRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

