/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.special;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.IModelObject;
import se.michaelthelin.spotify.model_objects.IPlaylistItem;
import se.michaelthelin.spotify.model_objects.miscellaneous.CurrentlyPlaying;
import se.michaelthelin.spotify.model_objects.specification.Episode;
import se.michaelthelin.spotify.model_objects.specification.Track;

@JsonDeserialize(builder=CurrentlyPlaying.Builder.class)
public class PlaybackQueue
extends AbstractModelObject {
    private final IPlaylistItem currentlyPlaying;
    private final List<IPlaylistItem> queue;

    private PlaybackQueue(Builder builder) {
        super(builder);
        this.currentlyPlaying = builder.currentlyPlaying;
        this.queue = builder.queue;
    }

    public IPlaylistItem getCurrentlyPlaying() {
        return this.currentlyPlaying;
    }

    public List<IPlaylistItem> getQueue() {
        return this.queue;
    }

    @Override
    public String toString() {
        return "PlaybackQueue{currentlyPlaying=" + this.currentlyPlaying + ", queue=" + this.queue + "}";
    }

    @Override
    public IModelObject.Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<PlaybackQueue> {
        @Override
        public PlaybackQueue createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            IPlaylistItem currentlyPlaying = this.hasAndNotNull(jsonObject, "currently_playing") ? this.asPlaylistItem(jsonObject.getAsJsonObject("currently_playing")) : null;
            ArrayList<IPlaylistItem> queue = new ArrayList<IPlaylistItem>();
            if (this.hasAndNotNull(jsonObject, "queue")) {
                for (JsonElement jsonElement : jsonObject.getAsJsonArray("queue")) {
                    IPlaylistItem queueItem = this.asPlaylistItem(jsonElement.getAsJsonObject());
                    queue.add(queueItem);
                }
            }
            return new Builder().setCurrentlyPlaying(currentlyPlaying).setQueue(queue).build();
        }

        private IPlaylistItem asPlaylistItem(JsonObject trackObj) {
            AbstractModelObject item = null;
            if (this.hasAndNotNull(trackObj, "type")) {
                String type = trackObj.get("type").getAsString().toLowerCase();
                if (type.equals("track")) {
                    item = new Track.JsonUtil().createModelObject(trackObj);
                } else if (type.equals("episode")) {
                    item = new Episode.JsonUtil().createModelObject(trackObj);
                }
            }
            return item;
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private IPlaylistItem currentlyPlaying;
        private List<IPlaylistItem> queue;

        public Builder setCurrentlyPlaying(IPlaylistItem currentlyPlaying) {
            this.currentlyPlaying = currentlyPlaying;
            return this;
        }

        public Builder setQueue(List<IPlaylistItem> queue) {
            this.queue = queue;
            return this;
        }

        @Override
        public PlaybackQueue build() {
            return new PlaybackQueue(this);
        }
    }
}

