/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.personalization.simplified;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.Track;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetUsersTopTracksRequest
extends AbstractDataRequest<Paging<Track>> {
    private GetUsersTopTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<Track> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new Track.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<Track, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder time_range(String time_range) {
            assert (time_range != null);
            assert (time_range.equals("long_term") || time_range.equals("medium_term") || time_range.equals("short_term"));
            return (Builder)this.setQueryParameter("time_range", time_range);
        }

        public GetUsersTopTracksRequest build() {
            this.setPath("/v1/me/top/tracks");
            return new GetUsersTopTracksRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

