/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.player;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.SpotifyApi;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.PagingCursorbased;
import se.michaelthelin.spotify.model_objects.specification.PlayHistory;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingCursorbasedRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetCurrentUsersRecentlyPlayedTracksRequest
extends AbstractDataRequest<PagingCursorbased<PlayHistory>> {
    private GetCurrentUsersRecentlyPlayedTracksRequest(Builder builder) {
        super(builder);
    }

    @Override
    public PagingCursorbased<PlayHistory> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new PlayHistory.JsonUtil().createModelObjectPagingCursorbased(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingCursorbasedRequest.Builder<PlayHistory, Date, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder after(Date after) {
            assert (after != null);
            return (Builder)this.setQueryParameter("after", SpotifyApi.formatDefaultDate(after));
        }

        public Builder before(Date before) {
            assert (before != null);
            return (Builder)this.setQueryParameter("before", SpotifyApi.formatDefaultDate(before));
        }

        public GetCurrentUsersRecentlyPlayedTracksRequest build() {
            this.setPath("/v1/me/player/recently-played");
            return new GetCurrentUsersRecentlyPlayedTracksRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

