/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.STATELESS)
public class SpotifyHttpRequestRetryStrategy
implements HttpRequestRetryStrategy {
    private final int maxRetries;
    private final TimeValue defaultRetryInterval;
    private final Set<Class<? extends IOException>> nonRetriableIOExceptionClasses;
    private final Set<Integer> retriableCodes;

    protected SpotifyHttpRequestRetryStrategy(int maxRetries, TimeValue defaultRetryInterval, Collection<Class<? extends IOException>> clazzes, Collection<Integer> codes) {
        Args.notNegative((int)maxRetries, (String)"maxRetries");
        Args.notNegative((long)defaultRetryInterval.getDuration(), (String)"defaultRetryInterval");
        this.maxRetries = maxRetries;
        this.defaultRetryInterval = defaultRetryInterval;
        this.nonRetriableIOExceptionClasses = new HashSet<Class<? extends IOException>>(clazzes);
        this.retriableCodes = new HashSet<Integer>(codes);
    }

    public SpotifyHttpRequestRetryStrategy(int maxRetries, TimeValue defaultRetryInterval) {
        this(maxRetries, defaultRetryInterval, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, NoRouteToHostException.class, SSLException.class), List.of(Integer.valueOf(503)));
    }

    public SpotifyHttpRequestRetryStrategy() {
        this(1, TimeValue.ofSeconds((long)1L));
    }

    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(exception, "exception");
        if (execCount > this.maxRetries) {
            return false;
        }
        if (this.nonRetriableIOExceptionClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableIOExceptionClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (request instanceof CancellableDependency && ((CancellableDependency)request).isCancelled()) {
            return false;
        }
        return this.handleAsIdempotent(request);
    }

    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        Objects.requireNonNull(response, "response");
        return execCount <= this.maxRetries && this.retriableCodes.contains(response.getCode());
    }

    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        Objects.requireNonNull(response, "response");
        return this.defaultRetryInterval;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return Method.isIdempotent((String)request.getMethod());
    }
}

