/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.enums;

import java.util.HashMap;
import java.util.Map;

public enum AlbumType {
    ALBUM("album"),
    COMPILATION("compilation"),
    SINGLE("single");

    private static final Map<String, AlbumType> map;
    public final String type;

    private AlbumType(String type) {
        this.type = type;
    }

    public static AlbumType keyOf(String type) {
        return map.get(type);
    }

    public String getType() {
        return this.type;
    }

    static {
        map = new HashMap<String, AlbumType>();
        for (AlbumType albumType : AlbumType.values()) {
            map.put(albumType.type, albumType);
        }
    }
}

