/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.miscellaneous;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;

@JsonDeserialize(builder=Builder.class)
public class AudioAnalysisMeta
extends AbstractModelObject {
    private final String analyzerVersion;
    private final String platform;
    private final String detailedStatus;
    private final Integer statusCode;
    private final Long timestamp;
    private final Float analysisTime;
    private final String inputProcess;

    private AudioAnalysisMeta(Builder builder) {
        super(builder);
        this.analyzerVersion = builder.analyzerVersion;
        this.platform = builder.platform;
        this.detailedStatus = builder.detailedStatus;
        this.statusCode = builder.statusCode;
        this.timestamp = builder.timestamp;
        this.analysisTime = builder.analysisTime;
        this.inputProcess = builder.inputProcess;
    }

    public String getAnalyzerVersion() {
        return this.analyzerVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getDetailedStatus() {
        return this.detailedStatus;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Float getAnalysisTime() {
        return this.analysisTime;
    }

    public String getInputProcess() {
        return this.inputProcess;
    }

    @Override
    public String toString() {
        return "AudioAnalysisMeta(analyzerVersion=" + this.analyzerVersion + ", platform=" + this.platform + ", detailedStatus=" + this.detailedStatus + ", statusCode=" + this.statusCode + ", timestamp=" + this.timestamp + ", analysisTime=" + this.analysisTime + ", inputProcess=" + this.inputProcess + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<AudioAnalysisMeta> {
        @Override
        public AudioAnalysisMeta createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setAnalysisTime(this.hasAndNotNull(jsonObject, "analysis_time") ? Float.valueOf(jsonObject.get("analysis_time").getAsFloat()) : null).setAnalyzerVersion(this.hasAndNotNull(jsonObject, "analyzer_version") ? jsonObject.get("analyzer_version").getAsString() : null).setDetailedStatus(this.hasAndNotNull(jsonObject, "detailed_status") ? jsonObject.get("detailed_status").getAsString() : null).setInputProcess(this.hasAndNotNull(jsonObject, "input_process") ? jsonObject.get("input_process").getAsString() : null).setPlatform(this.hasAndNotNull(jsonObject, "platform") ? jsonObject.get("platform").getAsString() : null).setStatusCode(this.hasAndNotNull(jsonObject, "status_code") ? Integer.valueOf(jsonObject.get("status_code").getAsInt()) : null).setTimestamp(this.hasAndNotNull(jsonObject, "timestamp") ? Long.valueOf(jsonObject.get("timestamp").getAsLong()) : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private String analyzerVersion;
        private String platform;
        private String detailedStatus;
        private Integer statusCode;
        private Long timestamp;
        private Float analysisTime;
        private String inputProcess;

        public Builder setAnalyzerVersion(String analyzerVersion) {
            this.analyzerVersion = analyzerVersion;
            return this;
        }

        public Builder setPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public Builder setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setAnalysisTime(Float analysisTime) {
            this.analysisTime = analysisTime;
            return this;
        }

        public Builder setInputProcess(String inputProcess) {
            this.inputProcess = inputProcess;
            return this;
        }

        @Override
        public AudioAnalysisMeta build() {
            return new AudioAnalysisMeta(this);
        }
    }
}

