/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.authorization.authorization_code.pkce;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.net.URI;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.credentials.AuthorizationCodeCredentials;
import se.michaelthelin.spotify.requests.AbstractRequest;

@JsonDeserialize(builder=Builder.class)
public class AuthorizationCodePKCERequest
extends AbstractRequest<AuthorizationCodeCredentials> {
    private AuthorizationCodePKCERequest(Builder builder) {
        super(builder);
    }

    @Override
    public AuthorizationCodeCredentials execute() throws IOException, SpotifyWebApiException, ParseException {
        return (AuthorizationCodeCredentials)new AuthorizationCodeCredentials.JsonUtil().createModelObject(this.postJson());
    }

    public static final class Builder
    extends AbstractRequest.Builder<AuthorizationCodeCredentials, Builder> {
        public Builder client_id(String client_id) {
            assert (client_id != null);
            assert (!client_id.isEmpty());
            return (Builder)this.setBodyParameter("client_id", client_id);
        }

        public Builder grant_type(String grant_type) {
            assert (grant_type != null);
            assert (grant_type.equals("authorization_code"));
            return (Builder)this.setBodyParameter("grant_type", grant_type);
        }

        public Builder code(String code) {
            assert (code != null);
            assert (!code.isEmpty());
            return (Builder)this.setBodyParameter("code", code);
        }

        public Builder redirect_uri(URI redirect_uri) {
            assert (redirect_uri != null);
            return (Builder)this.setBodyParameter("redirect_uri", redirect_uri.toString());
        }

        public Builder code_verifier(String code_verifier) {
            assert (code_verifier != null);
            assert (!code_verifier.isEmpty());
            return (Builder)this.setBodyParameter("code_verifier", code_verifier);
        }

        public AuthorizationCodePKCERequest build() {
            this.setContentType(ContentType.APPLICATION_FORM_URLENCODED);
            this.setHost("accounts.spotify.com");
            this.setPort(443);
            this.setScheme("https");
            this.setPath("/api/token");
            return new AuthorizationCodePKCERequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

