/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.PlaylistTrack;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetPlaylistsItemsRequest
extends AbstractDataRequest<Paging<PlaylistTrack>> {
    private GetPlaylistsItemsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<PlaylistTrack> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new PlaylistTrack.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<PlaylistTrack, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.isEmpty());
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder fields(String fields) {
            assert (fields != null);
            assert (!fields.isEmpty());
            return (Builder)this.setQueryParameter("fields", fields);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 100);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public Builder additionalTypes(String additionalTypes) {
            assert (additionalTypes != null);
            assert (additionalTypes.matches("((^|,)(episode|track))+$"));
            return (Builder)this.setQueryParameter("additional_types", additionalTypes);
        }

        public GetPlaylistsItemsRequest build() {
            this.setPath("/v1/playlists/{playlist_id}/tracks");
            return new GetPlaylistsItemsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

