/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.StringEntity;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class UploadCustomPlaylistCoverImageRequest
extends AbstractDataRequest<String> {
    private UploadCustomPlaylistCoverImageRequest(Builder builder) {
        super(builder);
    }

    @Override
    public String execute() throws IOException, SpotifyWebApiException, ParseException {
        return this.putJson();
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<String, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.isEmpty());
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder image_data(String image_data) {
            assert (image_data != null);
            assert (!image_data.isEmpty());
            assert (image_data.getBytes().length <= 256000);
            return (Builder)this.setBody((HttpEntity)new StringEntity(image_data, ContentType.IMAGE_JPEG));
        }

        public UploadCustomPlaylistCoverImageRequest build() {
            this.setContentType(ContentType.IMAGE_JPEG);
            this.setPath("/v1/playlists/{playlist_id}/images");
            return new UploadCustomPlaylistCoverImageRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

