/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.tracks;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Track;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetTrackRequest
extends AbstractDataRequest<Track> {
    private GetTrackRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Track execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Track)new Track.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Track, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder id(String id) {
            assert (id != null);
            assert (!id.isEmpty());
            return (Builder)this.setPathParameter("id", id);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetTrackRequest build() {
            this.setPath("/v1/tracks/{id}");
            return new GetTrackRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

