/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.miscellaneous;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import se.michaelthelin.spotify.SpotifyApi;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.specification.Episode;

@JsonDeserialize(builder=Builder.class)
public class SavedEpisode
extends AbstractModelObject {
    private final Date addedAt;
    private final Episode episode;

    private SavedEpisode(Builder builder) {
        super(builder);
        this.addedAt = builder.addedAt;
        this.episode = builder.episode;
    }

    public Date getAddedAt() {
        return this.addedAt;
    }

    public Episode getEpisode() {
        return this.episode;
    }

    @Override
    public String toString() {
        return "SavedEpisode(addedAt=" + this.addedAt + ", episode=" + this.episode + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<SavedEpisode> {
        @Override
        public SavedEpisode createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            try {
                return new Builder().setAddedAt(this.hasAndNotNull(jsonObject, "added_at") ? SpotifyApi.parseDefaultDate(jsonObject.get("added_at").getAsString()) : null).setEpisode(this.hasAndNotNull(jsonObject, "episode") ? new Episode.JsonUtil().createModelObject(jsonObject.getAsJsonObject("episode")) : null).build();
            }
            catch (ParseException e) {
                SpotifyApi.LOGGER.log(Level.SEVERE, e.getMessage());
                return null;
            }
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private Date addedAt;
        private Episode episode;

        public Builder setAddedAt(Date addedAt) {
            this.addedAt = addedAt;
            return this;
        }

        public Builder setEpisode(Episode episode) {
            this.episode = episode;
            return this;
        }

        @Override
        public SavedEpisode build() {
            return new SavedEpisode(this);
        }
    }
}

