/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import se.michaelthelin.spotify.enums.ModelObjectType;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.specification.ExternalUrl;
import se.michaelthelin.spotify.model_objects.specification.Followers;
import se.michaelthelin.spotify.model_objects.specification.Image;
import se.michaelthelin.spotify.requests.data.personalization.interfaces.IArtistTrackModelObject;
import se.michaelthelin.spotify.requests.data.search.interfaces.ISearchModelObject;

@JsonDeserialize(builder=Builder.class)
public class Artist
extends AbstractModelObject
implements IArtistTrackModelObject,
ISearchModelObject {
    private final ExternalUrl externalUrls;
    private final Followers followers;
    private final String[] genres;
    private final String href;
    private final String id;
    private final Image[] images;
    private final String name;
    private final Integer popularity;
    private final ModelObjectType type;
    private final String uri;

    private Artist(Builder builder) {
        super(builder);
        this.externalUrls = builder.externalUrls;
        this.followers = builder.followers;
        this.genres = builder.genres;
        this.href = builder.href;
        this.id = builder.id;
        this.images = builder.images;
        this.name = builder.name;
        this.popularity = builder.popularity;
        this.type = builder.type;
        this.uri = builder.uri;
    }

    public ExternalUrl getExternalUrls() {
        return this.externalUrls;
    }

    public Followers getFollowers() {
        return this.followers;
    }

    public String[] getGenres() {
        return this.genres;
    }

    public String getHref() {
        return this.href;
    }

    public String getId() {
        return this.id;
    }

    public Image[] getImages() {
        return this.images;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPopularity() {
        return this.popularity;
    }

    public ModelObjectType getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    public String toString() {
        return "Artist(name=" + this.name + ", externalUrls=" + this.externalUrls + ", followers=" + this.followers + ", genres=" + Arrays.toString(this.genres) + ", href=" + this.href + ", id=" + this.id + ", images=" + Arrays.toString(this.images) + ", popularity=" + this.popularity + ", type=" + this.type + ", uri=" + this.uri + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artist artist = (Artist)o;
        return Objects.equals(this.id, artist.id) && Objects.equals(this.name, artist.name) && Objects.equals(this.uri, artist.uri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.uri);
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<Artist> {
        @Override
        public Artist createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setExternalUrls(this.hasAndNotNull(jsonObject, "external_urls") ? new ExternalUrl.JsonUtil().createModelObject(jsonObject.getAsJsonObject("external_urls")) : null).setFollowers(this.hasAndNotNull(jsonObject, "followers") ? new Followers.JsonUtil().createModelObject(jsonObject.getAsJsonObject("followers")) : null).setGenres(this.hasAndNotNull(jsonObject, "genres") ? (String[])new Gson().fromJson((JsonElement)jsonObject.getAsJsonArray("genres"), String[].class) : null).setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setId(this.hasAndNotNull(jsonObject, "id") ? jsonObject.get("id").getAsString() : null).setImages(this.hasAndNotNull(jsonObject, "images") ? (Image[])new Image.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("images")) : null).setName(this.hasAndNotNull(jsonObject, "name") ? jsonObject.get("name").getAsString() : null).setPopularity(this.hasAndNotNull(jsonObject, "popularity") ? Integer.valueOf(jsonObject.get("popularity").getAsInt()) : null).setType(this.hasAndNotNull(jsonObject, "type") ? ModelObjectType.keyOf(jsonObject.get("type").getAsString().toLowerCase()) : null).setUri(this.hasAndNotNull(jsonObject, "uri") ? jsonObject.get("uri").getAsString() : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private ExternalUrl externalUrls;
        private Followers followers;
        private String[] genres;
        private String href;
        private String id;
        private Image[] images;
        private String name;
        private Integer popularity;
        private ModelObjectType type;
        private String uri;

        public Builder setExternalUrls(ExternalUrl externalUrls) {
            this.externalUrls = externalUrls;
            return this;
        }

        public Builder setFollowers(Followers followers) {
            this.followers = followers;
            return this;
        }

        public Builder setGenres(String ... genres) {
            this.genres = genres;
            return this;
        }

        public Builder setHref(String href) {
            this.href = href;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setImages(Image ... images) {
            this.images = images;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPopularity(Integer popularity) {
            this.popularity = popularity;
            return this;
        }

        public Builder setType(ModelObjectType type) {
            this.type = type;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public Artist build() {
            return new Artist(this);
        }
    }
}

