/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.model_objects.specification;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Objects;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.specification.Image;

@JsonDeserialize(builder=Builder.class)
public class Category
extends AbstractModelObject {
    private final String href;
    private final Image[] icons;
    private final String id;
    private final String name;

    private Category(Builder builder) {
        super(builder);
        this.href = builder.href;
        this.icons = builder.icons;
        this.id = builder.id;
        this.name = builder.name;
    }

    public String getHref() {
        return this.href;
    }

    public Image[] getIcons() {
        return this.icons;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "Category(href=" + this.href + ", icons=" + Arrays.toString(this.icons) + ", id=" + this.id + ", name=" + this.name + ")";
    }

    @Override
    public Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        return Objects.equals(this.href, category.href) && Objects.equals(this.id, category.id) && Objects.equals(this.name, category.name);
    }

    public int hashCode() {
        return Objects.hash(this.href, this.id, this.name);
    }

    public static final class JsonUtil
    extends AbstractModelObject.JsonUtil<Category> {
        @Override
        public Category createModelObject(JsonObject jsonObject) {
            if (jsonObject == null || jsonObject.isJsonNull()) {
                return null;
            }
            return new Builder().setHref(this.hasAndNotNull(jsonObject, "href") ? jsonObject.get("href").getAsString() : null).setIcons(this.hasAndNotNull(jsonObject, "icons") ? (Image[])new Image.JsonUtil().createModelObjectArray(jsonObject.getAsJsonArray("icons")) : null).setId(this.hasAndNotNull(jsonObject, "id") ? jsonObject.get("id").getAsString() : null).setName(this.hasAndNotNull(jsonObject, "name") ? jsonObject.get("name").getAsString() : null).build();
        }
    }

    public static final class Builder
    extends AbstractModelObject.Builder {
        private String href;
        private Image[] icons;
        private String id;
        private String name;

        public Builder setHref(String href) {
            this.href = href;
            return this;
        }

        public Builder setIcons(Image ... icons) {
            this.icons = icons;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Category build() {
            return new Category(this);
        }
    }
}

