/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.library;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.neovisionaries.i18n.CountryCode;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.miscellaneous.SavedEpisode;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetUsersSavedEpisodesRequest
extends AbstractDataRequest<Paging<SavedEpisode>> {
    private GetUsersSavedEpisodesRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<SavedEpisode> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new SavedEpisode.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<SavedEpisode, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder market(CountryCode market) {
            assert (market != null);
            return (Builder)this.setQueryParameter("market", market);
        }

        public GetUsersSavedEpisodesRequest build() {
            this.setPath("/v1/me/episodes");
            return new GetUsersSavedEpisodesRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

