/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class ChangePlaylistsDetailsRequest
extends AbstractDataRequest<String> {
    private ChangePlaylistsDetailsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public String execute() throws IOException, SpotifyWebApiException, ParseException {
        return this.putJson();
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<String, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.isEmpty());
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public Builder name(String name) {
            assert (name != null);
            assert (!name.isEmpty());
            return (Builder)this.setBodyParameter("name", name);
        }

        public Builder public_(Boolean public_) {
            return (Builder)this.setBodyParameter("public", public_);
        }

        public Builder collaborative(Boolean collaborative) {
            return (Builder)this.setBodyParameter("collaborative", collaborative);
        }

        public Builder description(String description) {
            assert (description != null);
            assert (!description.isEmpty());
            return (Builder)this.setBodyParameter("description", description);
        }

        public ChangePlaylistsDetailsRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/playlists/{playlist_id}");
            return new ChangePlaylistsDetailsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

