/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Playlist;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class CreatePlaylistRequest
extends AbstractDataRequest<Playlist> {
    private CreatePlaylistRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Playlist execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Playlist)new Playlist.JsonUtil().createModelObject(this.postJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Playlist, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.isEmpty());
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public Builder name(String name) {
            assert (name != null);
            assert (!name.isEmpty());
            return (Builder)this.setBodyParameter("name", name);
        }

        public Builder public_(Boolean public_) {
            return (Builder)this.setBodyParameter("public", public_);
        }

        public Builder collaborative(Boolean collaborative) {
            return (Builder)this.setBodyParameter("collaborative", collaborative);
        }

        public Builder description(String description) {
            assert (description != null);
            assert (!description.isEmpty());
            return (Builder)this.setBodyParameter("description", description);
        }

        public CreatePlaylistRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/users/{user_id}/playlists");
            return new CreatePlaylistRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

