/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Image;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetPlaylistCoverImageRequest
extends AbstractDataRequest<Image[]> {
    private GetPlaylistCoverImageRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Image[] execute() throws IOException, SpotifyWebApiException, ParseException {
        return (Image[])new Image.JsonUtil().createModelObjectArray(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<Image[], Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder playlist_id(String playlist_id) {
            assert (playlist_id != null);
            assert (!playlist_id.isEmpty());
            return (Builder)this.setPathParameter("playlist_id", playlist_id);
        }

        public GetPlaylistCoverImageRequest build() {
            this.setPath("/v1/playlists/{playlist_id}/images");
            return new GetPlaylistCoverImageRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

